/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.ChatDataDictionary;
import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.model.interfaces.ProfileEntity;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.util.TimeUtils;
import com.zoyi.channel.plugin.android.util.UIUtils;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.view.layout.AvatarLayout;
import com.zoyi.channel.plugin.android.view.layout.CHTextView;

public class BaseMessageHolder
extends RecyclerView.ViewHolder {
    CHTextView guestMessageTime;
    LinearLayout guestMessageTextLayout;
    LinearLayout managerMessageProfileLayout;
    AvatarLayout managerMessageAvatar;
    CHTextView managerMessageName;
    CHTextView managerMessageTime;
    LinearLayout managerMessageTextLayout;
    LinearLayout contentLayout;
    private Context context;

    public static BaseMessageHolder newInstance(ViewGroup parent, MessageType messageType) {
        return new BaseMessageHolder(BaseMessageHolder.getItemView(parent, messageType), messageType);
    }

    public BaseMessageHolder(View itemView, MessageType messageType) {
        super(itemView);
        this.context = itemView.getContext();
        switch (messageType) {
            case GUEST_TEXT_MESSAGE: 
            case GUEST_IMAGE_MESSAGE: 
            case GUEST_FILE_MESSAGE: 
            case GUEST_WEB_MESSAGE: 
            case SENDING: {
                this.guestMessageTime = (CHTextView)itemView.findViewById(R.id.ch_text_guest_message_time);
                this.guestMessageTextLayout = (LinearLayout)itemView.findViewById(R.id.ch_message_content_guest_text);
                break;
            }
            default: {
                this.managerMessageProfileLayout = (LinearLayout)itemView.findViewById(R.id.ch_layout_manager_message_profile);
                this.managerMessageAvatar = (AvatarLayout)itemView.findViewById(R.id.ch_avater_manager_message);
                this.managerMessageTime = (CHTextView)itemView.findViewById(R.id.ch_text_manager_message_time);
                this.managerMessageName = (CHTextView)itemView.findViewById(R.id.ch_text_manager_message_name);
                this.managerMessageTextLayout = (LinearLayout)itemView.findViewById(R.id.ch_message_content_manager_text);
            }
        }
        this.contentLayout = (LinearLayout)itemView.findViewById(R.id.ch_layout_message_content);
    }

    protected static View getItemView(ViewGroup parent, MessageType messageType) {
        LayoutInflater inflater = LayoutInflater.from((Context)parent.getContext());
        switch (messageType) {
            case GUEST_TEXT_MESSAGE: 
            case GUEST_IMAGE_MESSAGE: 
            case GUEST_FILE_MESSAGE: 
            case GUEST_WEB_MESSAGE: 
            case SENDING: {
                return inflater.inflate(R.layout.ch_plugin_item_message_guest, parent, false);
            }
        }
        return inflater.inflate(R.layout.ch_plugin_item_message_manager2, parent, false);
    }

    public void bind(Message message, MessageType messageType, boolean isConnectedMessage) {
        this.setLayout(message, messageType, isConnectedMessage);
    }

    private void setLayout(Message message, MessageType messageType, boolean isConnectedMessage) {
        switch (messageType) {
            case GUEST_TEXT_MESSAGE: 
            case GUEST_IMAGE_MESSAGE: 
            case GUEST_FILE_MESSAGE: 
            case GUEST_WEB_MESSAGE: 
            case SENDING: {
                this.setGuestMessage(message, isConnectedMessage);
                break;
            }
            default: {
                this.setManagerMessage(message, isConnectedMessage);
            }
        }
    }

    private void setGuestMessage(Message message, boolean isConnectedMessage) {
        if (message != null) {
            this.guestMessageTime.setVisibility(UIUtils.getVisible(!isConnectedMessage, true));
            this.guestMessageTime.setText(TimeUtils.getTime(message.getCreatedAt()));
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -2);
            params.gravity = 0x800005;
            this.contentLayout.setGravity(0x800005);
            this.contentLayout.setLayoutParams((ViewGroup.LayoutParams)params);
        }
    }

    private void setManagerMessage(Message message, boolean isConnectedMessage) {
        if (message != null) {
            ProfileEntity profile = ChatDataDictionary.getInstance().getProfile(message.getPersonType(), message.getPersonId());
            this.managerMessageProfileLayout.setVisibility(UIUtils.getVisible(!isConnectedMessage, true));
            this.managerMessageAvatar.set(profile);
            this.managerMessageTime.setText(TimeUtils.getTime(message.getCreatedAt()));
            this.managerMessageName.setText(profile.getName());
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -2);
            params.leftMargin = (int)Utils.dpToPx(this.context, 46.0f);
            this.contentLayout.setLayoutParams((ViewGroup.LayoutParams)params);
        }
    }
}

