/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.view;

import android.content.Context;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnChangeInputStateListener;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnProfileEventListener;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.channel.plugin.android.util.UIUtils;
import com.zoyi.channel.plugin.android.util.io.Keyboard;
import com.zoyi.channel.plugin.android.view.handler.EditTextChangedListener;
import com.zoyi.channel.plugin.android.view.layout.CHTextView;
import com.zoyi.channel.plugin.android.view.layout.WatchedEditText;
import java.math.BigDecimal;

public class ProfileMessageView
extends LinearLayout {
    private Context context;
    protected OnProfileEventListener onProfileEventListener;
    protected OnChangeInputStateListener onChangeInputStateListener;
    private CHTextView textName;
    private CHTextView textError;
    private CHTextView textPage;
    private CHTextView textTotalPage;
    private LinearLayout inputLayout;
    private FrameLayout inputItems;
    private WatchedEditText editText;
    private ImageButton sendButton;
    private View loadingView;
    private View completeLayout;
    private CHTextView textComplete;
    protected String key;
    protected String type;
    protected boolean hasError;
    protected boolean isLoading;
    protected boolean hasEditTextFocus = false;

    public ProfileMessageView(Context context, OnProfileEventListener onProfileEventListener, OnChangeInputStateListener onChangeInputStateListener) {
        super(context);
        this.init(context, onProfileEventListener, onChangeInputStateListener);
    }

    private void init(Context context, final OnProfileEventListener onProfileEventListener, OnChangeInputStateListener onChangeInputStateListener) {
        this.context = context;
        View view = LayoutInflater.from((Context)context).inflate(R.layout.ch_plugin_layout_profile_item, (ViewGroup)this);
        this.textName = (CHTextView)view.findViewById(R.id.ch_text_profile_item_name);
        this.textError = (CHTextView)view.findViewById(R.id.ch_text_profile_item_error);
        this.textPage = (CHTextView)view.findViewById(R.id.ch_text_profile_item_page);
        this.textTotalPage = (CHTextView)view.findViewById(R.id.ch_text_profile_item_total_page);
        this.inputLayout = (LinearLayout)view.findViewById(R.id.ch_layout_profile_item_input);
        this.inputItems = (FrameLayout)view.findViewById(R.id.ch_layout_profile_item_input_items);
        this.editText = (WatchedEditText)view.findViewById(R.id.ch_edit_profile_item_input);
        this.sendButton = (ImageButton)view.findViewById(R.id.ch_button_profile_item_input);
        this.loadingView = view.findViewById(R.id.ch_view_profile_item_input_loading);
        this.completeLayout = view.findViewById(R.id.ch_layout_profile_item_complete);
        this.textComplete = (CHTextView)view.findViewById(R.id.ch_text_profile_item_complete);
        this.onProfileEventListener = onProfileEventListener;
        this.onChangeInputStateListener = onChangeInputStateListener;
        this.initInputView(context);
        this.initInputViewEventListener();
        this.sendButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (onProfileEventListener != null) {
                    onProfileEventListener.onSendButtonClick(ProfileMessageView.this.key, ProfileMessageView.this.getValue(), ProfileMessageView.this.getInputState());
                }
            }
        });
    }

    protected void initInputView(Context context) {
    }

    protected void initInputViewEventListener() {
        this.editText.setWatchedTextChangedListener(new EditTextChangedListener(){

            @Override
            public void onWatchedTextChanged(String text) {
                if (CompareUtils.isSame(" ", text)) {
                    ProfileMessageView.this.editText.setText("");
                } else {
                    if (ProfileMessageView.this.hasEditTextFocus) {
                        ProfileMessageView.this.onChangeInputStateListener.onUpdateInputState(ProfileMessageView.this.key, text, !text.isEmpty());
                    }
                    ProfileMessageView.this.setStyle(false, ProfileMessageView.this.editText.isFocused(), ProfileMessageView.this.isValidInputState(text), ProfileMessageView.this.isLoading);
                }
            }
        });
        this.editText.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                ProfileMessageView.this.hasEditTextFocus = hasFocus;
                ProfileMessageView.this.setStyle(ProfileMessageView.this.hasError, hasFocus, ProfileMessageView.this.isValidInputState(ProfileMessageView.this.editText.getText().toString()), ProfileMessageView.this.isLoading);
                ProfileMessageView.this.onProfileEventListener.onChangeFocus(hasFocus);
            }
        });
        this.editText.setOnEditorActionListener(new TextView.OnEditorActionListener(){

            public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
                if (actionId == 6 || actionId == 5) {
                    if (ProfileMessageView.this.isValidInputState(ProfileMessageView.this.getValue())) {
                        ProfileMessageView.this.onProfileEventListener.onSendButtonClick(ProfileMessageView.this.key, ProfileMessageView.this.getValue(), ProfileMessageView.this.getInputState());
                    }
                    return true;
                }
                return false;
            }
        });
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setType(String type) {
        if (type != null) {
            this.type = type;
            switch (type) {
                case "Number": {
                    this.editText.setInputType(8194);
                    break;
                }
                default: {
                    this.editText.setInputType(1);
                }
            }
        }
    }

    private void initLayout() {
        this.textName.setVisibility(8);
        this.textError.setVisibility(8);
        this.textPage.setVisibility(8);
        this.textTotalPage.setVisibility(8);
        this.inputLayout.setVisibility(8);
        this.completeLayout.setVisibility(8);
        this.textComplete.setVisibility(8);
    }

    public void setState(String name, String error, int page, int totalPage, Object value, Object inputState, boolean isLoading, boolean hasCurrentViewFocus, boolean isLastProfile) {
        this.initLayout();
        if (this.isValueExists(value)) {
            this.textName.setText(name);
            this.completeLayout.setVisibility(0);
            this.textComplete.setVisibility(0);
            this.textComplete.setText(this.getFormattedString(value));
            this.setCompleteStyle();
        } else {
            this.textName.setText(name);
            this.textError.setText(error);
            this.textPage.setVisibility(0);
            this.textPage.setText(String.valueOf(page));
            this.textTotalPage.setVisibility(0);
            this.textTotalPage.setText(String.format("/%d", totalPage));
            this.inputLayout.setVisibility(0);
            this.setInputState(inputState, isLoading, isLastProfile);
            this.setStyle(!TextUtils.isEmpty((CharSequence)error), this.isInputViewFocused(), this.isValidInputState(inputState), isLoading);
            if (hasCurrentViewFocus) {
                this.requestFocusInputView();
            }
        }
    }

    private void setCompleteStyle() {
        this.hasError = false;
        this.isLoading = false;
        this.textError.setVisibility(8);
        this.textName.setVisibility(0);
    }

    protected void setStyle(boolean hasError, boolean hasFocus, boolean inputStateValid, boolean isLoading) {
        this.hasError = hasError;
        this.isLoading = isLoading;
        if (hasError) {
            this.textError.setVisibility(0);
            this.textName.setVisibility(8);
            this.inputLayout.setBackgroundResource(R.drawable.ch_plugin_profile_message_input_wrong);
            this.sendButton.setImageResource(R.drawable.ch_send_error);
        } else if (hasFocus) {
            this.textError.setVisibility(8);
            this.textName.setVisibility(0);
            this.inputLayout.setBackgroundResource(R.drawable.ch_plugin_profile_message_input);
            this.sendButton.setImageResource(R.drawable.ch_send);
        } else {
            this.textError.setVisibility(8);
            this.textName.setVisibility(0);
            this.inputLayout.setBackgroundResource(R.drawable.ch_plugin_profile_message_input_out_focus);
            this.sendButton.setImageResource(R.drawable.ch_send);
        }
        this.loadingView.setVisibility(UIUtils.getVisible(isLoading, true));
        this.sendButton.setVisibility(UIUtils.getVisible(inputStateValid && !isLoading, true));
    }

    protected void overrideInputView(View view) {
        this.editText.setVisibility(8);
        this.inputItems.addView(view);
    }

    protected boolean isInputViewFocused() {
        return this.editText.isFocused();
    }

    protected void requestFocusInputView() {
        this.editText.requestFocus();
        Keyboard.open(this.context, (View)this.editText);
    }

    protected Object getInputState() {
        return this.editText.getText().toString();
    }

    protected void setInputState(Object inputState, boolean isLoading, boolean isLastProfile) {
        this.editText.setText(inputState == null ? "" : this.getFormattedString(inputState));
        this.editText.setSelection(inputState == null ? 0 : this.getFormattedString(inputState).length());
        this.editText.setEnabled(!isLoading);
        this.editText.setImeOptions(isLastProfile ? 6 : 5);
    }

    protected Object getValue() {
        String inputValue = this.editText.getText().toString();
        if (CompareUtils.isSame("Number", this.getType())) {
            try {
                return Double.valueOf(inputValue);
            }
            catch (NumberFormatException exception) {
                L.e(exception.getMessage());
            }
        }
        return inputValue;
    }

    protected String getType() {
        return this.type;
    }

    protected boolean isValidInputState(Object value) {
        return value != null && !TextUtils.isEmpty((CharSequence)value.toString());
    }

    protected String getFormattedString(@NonNull Object object) {
        if (object instanceof Double) {
            BigDecimal bigDecimal = new BigDecimal(object.toString());
            String numberValue = bigDecimal.toString();
            if (numberValue.endsWith(".0")) {
                return numberValue.replace(".0", "");
            }
            return numberValue;
        }
        return object.toString();
    }

    private boolean isValueExists(Object value) {
        return value != null && !TextUtils.isEmpty((CharSequence)value.toString());
    }
}

