package com.zoyi.channel.plugin.android.util;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Parcelable;

import com.zoyi.channel.plugin.android.global.Const;

/**
 * Created by mika on 2016. 4. 6..
 */
public class IntentUtils {
  private Context context;
  private Intent intent;

  public static IntentUtils setNextActivity(Context context, Class<?> clazz) {
    IntentUtils intentUtils = new IntentUtils();
    intentUtils.context = context;
    intentUtils.intent = new Intent(context, clazz);
    return intentUtils;
  }

  public IntentUtils() { }

  private IntentUtils(Context context, Intent intent) {
    this.context = context;
    this.intent = intent;
  }

  public IntentUtils putExtra(String key, Integer value) {
    if (value != null) {
      intent.putExtra(key, value);
    }
    return this;
  }

  public IntentUtils putExtra(String key, Long value) {
    if (value != null) {
      intent.putExtra(key, value);
    }
    return this;
  }

  public IntentUtils putExtra(String key, String value) {
    if (value != null) {
      intent.putExtra(key, value);
    }
    return this;
  }

  public IntentUtils putExtra(String key, Boolean value) {
    if (value != null) {
      intent.putExtra(key, value);
    }
    return this;
  }

  public IntentUtils putExtra(String key, Parcelable value) {
    if (value != null) {
      intent.putExtra(key, value);
    }
    return this;
  }

  public void startActivity() {
    if (context != null && intent != null) {
      try {
        context.startActivity(intent);
      } catch (Exception ex) {
      }
    }
  }

  public void startActivityForResult(int requestCode) {
    if (context instanceof Activity) {
      intent.putExtra(Const.REQUEST_CODE_INTENT_KEY, requestCode);
      ((Activity) context).startActivityForResult(intent, requestCode);
    }
  }

  public static IntentUtils setUrl(Context context, String url) {
    IntentUtils intentUtils = new IntentUtils(context, new Intent(Intent.ACTION_VIEW));
    try {
      Uri uri = Uri.parse(url);
      if (uri.getScheme() == null || uri.getScheme().isEmpty()) {
        uri = Uri.parse("http://" + url);
      }
      intentUtils.intent.setData(uri);
    } catch (Exception ex) {
      L.e(ex.getMessage());
      intentUtils.intent = null;
    }
    return intentUtils;
  }

  public static IntentUtils setEmail(Context context, String email) {
    Uri uri;
    try {
      uri = Uri.parse(String.format("mailto:%s", email));
    } catch (Exception ignored) {
      return new IntentUtils(context, null);
    }
    return new IntentUtils(context, new Intent(Intent.ACTION_SENDTO, uri));
  }

  public static IntentUtils setPhone(Context context, String phoneNumber) {
    Uri uri;
    try {
      uri = Uri.parse(String.format("tel:%s", phoneNumber));
    } catch (Exception ignored) {
      return new IntentUtils(context, null);
    }
    return new IntentUtils(context, new Intent(Intent.ACTION_CALL, uri));
  }
}
