package com.zoyi.channel.plugin.android.activity.chat.utils;

import android.content.Context;
import android.graphics.Color;
import android.support.annotation.DrawableRes;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.Manager;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.model.interfaces.ProfileEntity;
import com.zoyi.channel.plugin.android.util.ResUtils;

public class ChatResponseManager {

  public static boolean showOnlyOneManager(Channel channel) {
    if (!channel.isWorking()) {
      return true;
    } else if (Channel.EXPECTED_RESPONSE_DELAY_DELAYED.equals(channel.getExpectedResponseDelay())) {
      return true;
    }
    return false;
  }

  public static String getResponseKey(Channel channel) {
    if (channel == null || channel.getExpectedResponseDelay() == null) {
      return null;
    }

    if (!channel.isWorking()) {
      return "ch.chat.expect_response_delay.out_of_working";
    }

    switch (channel.getExpectedResponseDelay()) {
      case Channel.EXPECTED_RESPONSE_DELAY_INSTANT:
        return "ch.chat.expect_response_delay.instant";

      case Channel.EXPECTED_RESPONSE_DELAY_NORMAL:
        return "ch.chat.expect_response_delay.normal";

      case Channel.EXPECTED_RESPONSE_DELAY_DELAYED:
        return "ch.chat.expect_response_delay.delayed";

      default:
        return null;
    }
  }

  public static String getResponseDescriptionKey(Channel channel) {
    if (channel == null || channel.getExpectedResponseDelay() == null) {
      return null;
    }

    if (!channel.isWorking()) {
      if (Const.AWAY_OPTION_ACTIVE.equals(channel.getAwayOption())) {
        return "ch.chat.expect_response_delay.out_of_working.description";
      } else {
        return "ch.chat.expect_response_delay.out_of_working.disabled";
      }
    }

    switch (channel.getExpectedResponseDelay()) {
      case Channel.EXPECTED_RESPONSE_DELAY_INSTANT:
        return "ch.chat.expect_response_delay.instant.description";

      case Channel.EXPECTED_RESPONSE_DELAY_NORMAL:
        return "ch.chat.expect_response_delay.normal.description";

      case Channel.EXPECTED_RESPONSE_DELAY_DELAYED:
        return "ch.chat.expect_response_delay.delayed.description";

      default:
        return null;
    }
  }

  public static String getShortResponseDescriptionKey(Channel channel) {
    if (channel == null || channel.getExpectedResponseDelay() == null) {
      return null;
    }

    if (!channel.isWorking()) {
      return "ch.chat.expect_response_delay.out_of_working.short_description";
    }

    switch (channel.getExpectedResponseDelay()) {
      case Channel.EXPECTED_RESPONSE_DELAY_INSTANT:
        return "ch.chat.expect_response_delay.instant.short_description";

      case Channel.EXPECTED_RESPONSE_DELAY_NORMAL:
        return "ch.chat.expect_response_delay.normal.short_description";

      case Channel.EXPECTED_RESPONSE_DELAY_DELAYED:
        return "ch.chat.expect_response_delay.delayed.short_description";

      default:
        return null;
    }
  }

  @DrawableRes
  public static int getResponseSymbol(Plugin plugin, Channel channel) {
    if (plugin == null || channel == null) {
      return 0;
    }

    int textColor = plugin.getTextColor();

    if (!channel.isWorking()) {
      return textColor == Color.WHITE
          ? R.drawable.ch_plugin_offhours_w
          : R.drawable.ch_plugin_offhours_b;
    }

    if (channel.getExpectedResponseDelay() == null) {
      return 0;
    }

    switch (channel.getExpectedResponseDelay()) {
      case Channel.EXPECTED_RESPONSE_DELAY_INSTANT:
        return textColor == Color.WHITE
            ? R.drawable.ch_plugin_fast_w
            : R.drawable.ch_plugin_fast_b;

      case Channel.EXPECTED_RESPONSE_DELAY_NORMAL:
        return textColor == Color.WHITE
            ? R.drawable.ch_plugin_normal_w
            : R.drawable.ch_plugin_normal_b;

      case Channel.EXPECTED_RESPONSE_DELAY_DELAYED:
        return textColor == Color.WHITE
            ? R.drawable.ch_plugin_delayed_w
            : R.drawable.ch_plugin_delayed_b;

      default:
        return 0;
    }
  }

  @DrawableRes
  public static int getManagerOnlineSymbol(Plugin plugin, ProfileEntity profileEntity) {
    if (plugin == null || profileEntity == null) {
      return 0;
    }

    if (profileEntity instanceof Manager && ((Manager) profileEntity).getOnline()) {
      return plugin.getTextColor() == Color.WHITE
          ? R.drawable.ch_plugin_normal_w
          : R.drawable.ch_plugin_normal_b;
    }
    return 0;
  }
}
