/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.content.Context;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.RecyclerView;
import android.view.KeyEvent;
import android.view.View;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.ChatDataDictionary;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnUserInfoListener;
import com.zoyi.channel.plugin.android.activity.chat.model.MobileNumberItem;
import com.zoyi.channel.plugin.android.activity.chat.model.UserInfoItem;
import com.zoyi.channel.plugin.android.activity.chat.type.UserInfoType;
import com.zoyi.channel.plugin.android.util.UIUtils;
import com.zoyi.channel.plugin.android.view.handler.EditTextChangedListener;
import com.zoyi.channel.plugin.android.view.layout.CHTextView;
import com.zoyi.channel.plugin.android.view.layout.WatchedEditText;

public class UserInfoMessageHolder
extends RecyclerView.ViewHolder
implements View.OnClickListener {
    private Context context;
    private LinearLayout inputLayout;
    private LinearLayout completeLayout;
    private CHTextView title;
    private CHTextView errorTitle;
    private CHTextView description;
    private CHTextView country;
    private LinearLayout inputLayouts;
    private LinearLayout nameLayout;
    private LinearLayout phoneLayout;
    private LinearLayout countryLayout;
    private WatchedEditText nameEdit;
    private WatchedEditText phoneEdit;
    private Button nameButton;
    private Button phoneButton;
    private OnUserInfoListener listener;
    private UserInfoItem item;
    private String code;
    private String mobileNumber;
    private boolean handle = false;
    private int checkedPosition;

    public UserInfoMessageHolder(View itemView, final OnUserInfoListener listener) {
        super(itemView);
        this.context = itemView.getContext();
        this.inputLayout = (LinearLayout)itemView.findViewById(R.id.layout_user_info_input);
        this.completeLayout = (LinearLayout)itemView.findViewById(R.id.layout_user_info_complete);
        this.title = (CHTextView)itemView.findViewById(R.id.user_info_title);
        this.errorTitle = (CHTextView)itemView.findViewById(R.id.user_info_error_title);
        this.description = (CHTextView)itemView.findViewById(R.id.user_info_description);
        this.inputLayouts = (LinearLayout)itemView.findViewById(R.id.user_info_layout);
        this.nameLayout = (LinearLayout)itemView.findViewById(R.id.user_info_layout_name);
        this.phoneLayout = (LinearLayout)itemView.findViewById(R.id.user_info_layout_phone);
        this.nameEdit = (WatchedEditText)itemView.findViewById(R.id.user_info_layout_name_input);
        this.nameButton = (Button)itemView.findViewById(R.id.user_info_layout_name_button);
        this.country = (CHTextView)itemView.findViewById(R.id.user_info_layout_phone_country);
        this.countryLayout = (LinearLayout)itemView.findViewById(R.id.user_info_layout_phone_country_layout);
        this.phoneEdit = (WatchedEditText)itemView.findViewById(R.id.user_info_layout_phone_input);
        this.phoneButton = (Button)itemView.findViewById(R.id.user_info_layout_phone_button);
        int active = ContextCompat.getColor((Context)this.context, (int)R.color.ch_cobalt);
        int deactive = ContextCompat.getColor((Context)this.context, (int)R.color.ch_light);
        this.nameEdit.setHandledButton(this.nameButton, active, deactive);
        this.nameEdit.setWatchedTextChangedListener(new EditTextChangedListener(){

            @Override
            public void onWatchedTextChanged(String s) {
                if (listener != null && UserInfoMessageHolder.this.handle) {
                    listener.userInfoChanged(s);
                }
            }
        });
        this.nameEdit.setOnEditorActionListener(new TextView.OnEditorActionListener(){

            public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
                switch (actionId) {
                    case 4: {
                        UserInfoMessageHolder.this.nameButton.callOnClick();
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                return true;
            }
        });
        this.phoneEdit.setHandledButton(this.phoneButton, active, deactive);
        this.phoneEdit.setWatchedTextChangedListener(new EditTextChangedListener(){

            @Override
            public void onWatchedTextChanged(String s) {
                if (listener != null && UserInfoMessageHolder.this.handle) {
                    listener.userInfoChanged(new MobileNumberItem(UserInfoMessageHolder.this.code, s, UserInfoMessageHolder.this.checkedPosition));
                }
                UserInfoMessageHolder.this.mobileNumber = s;
            }
        });
        this.phoneEdit.setOnEditorActionListener(new TextView.OnEditorActionListener(){

            public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
                switch (actionId) {
                    case 4: {
                        UserInfoMessageHolder.this.phoneButton.callOnClick();
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                return true;
            }
        });
        this.nameButton.setOnClickListener((View.OnClickListener)this);
        this.phoneButton.setOnClickListener((View.OnClickListener)this);
        this.countryLayout.setOnClickListener((View.OnClickListener)this);
        this.code = "";
        this.mobileNumber = "";
        this.checkedPosition = -1;
        this.listener = listener;
    }

    private void initLayout(UserInfoItem item) {
        this.title.setVisibility(UIUtils.getVisible(!item.hasError(), true));
        this.errorTitle.setVisibility(UIUtils.getVisible(item.hasError(), true));
        this.inputLayout.setVisibility(UIUtils.getVisible(!UserInfoType.COMPLETE.equals((Object)item.getUserInfoType()), true));
        this.completeLayout.setVisibility(UIUtils.getVisible(UserInfoType.COMPLETE.equals((Object)item.getUserInfoType()), true));
        for (int i = 0; i < this.inputLayouts.getChildCount(); ++i) {
            this.inputLayouts.getChildAt(i).setVisibility(8);
        }
        switch (item.getUserInfoType()) {
            case NAME: {
                this.nameLayout.setVisibility(0);
                break;
            }
            case MOBILE_NUMBER: {
                this.phoneLayout.setVisibility(0);
            }
        }
    }

    public void set(UserInfoItem item) {
        this.item = item;
        ChatDataDictionary dictionary = ChatDataDictionary.getInstance();
        this.initLayout(item);
        this.handle = true;
        switch (item.getUserInfoType()) {
            case NAME: {
                this.nameEdit.setText(dictionary.getUserName());
                if (item.hasError()) {
                    this.errorTitle.setTextByKey("ch.name_verification.error.title");
                    this.description.setText(item.getError());
                    this.nameEdit.selectAll();
                    break;
                }
                this.title.setTextByKey("ch.name_verification.title");
                this.description.setTextByKey("ch.name_verification.description");
                break;
            }
            case MOBILE_NUMBER: {
                MobileNumberItem mobileNumberItem = dictionary.getUserMobilNumber();
                if (mobileNumberItem != null) {
                    this.code = mobileNumberItem.getCountry();
                    this.mobileNumber = mobileNumberItem.getMobileNumber();
                    this.checkedPosition = mobileNumberItem.getCheckedPosition();
                    this.country.setText(String.format("+%s", mobileNumberItem.getCountry()));
                    this.phoneEdit.setText(mobileNumberItem.getMobileNumber());
                }
                if (item.hasError()) {
                    this.errorTitle.setTextByKey("ch.mobile_verification.error.title");
                    this.description.setText(item.getError());
                    this.phoneEdit.selectAll();
                    break;
                }
                this.title.setTextByKey("ch.mobile_verification.title");
                this.description.setTextByKey("ch.mobile_verification.description");
            }
        }
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.user_info_layout_phone_country_layout && this.listener != null && this.handle) {
            this.listener.getCountries(this.getAdapterPosition());
        }
        if ((id2 == R.id.user_info_layout_name_button || id2 == R.id.user_info_layout_phone_button) && this.listener != null && this.item != null && this.handle) {
            this.listener.sendUserInfo(this.item);
        }
    }
}

