/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.view;

import android.content.Context;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.View;
import android.widget.TextView;
import com.google.i18n.phonenumbers.NumberParseException;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.Phonenumber;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnChangeInputStateListener;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnCountryCodeSelectorClickListener;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnProfileEventListener;
import com.zoyi.channel.plugin.android.activity.chat.model.MobileNumber;
import com.zoyi.channel.plugin.android.activity.chat.view.MobileNumberProfileInputView;
import com.zoyi.channel.plugin.android.activity.chat.view.ProfileMessageView;
import com.zoyi.channel.plugin.android.util.CountryUtils;
import com.zoyi.channel.plugin.android.view.handler.EditTextChangedListener;

public class MobileNumberProfileMessageView
extends ProfileMessageView {
    private MobileNumberProfileInputView mobileNumberProfileInputView;

    public MobileNumberProfileMessageView(Context context, OnProfileEventListener onProfileEventListener, OnChangeInputStateListener onChangeInputStateListener) {
        super(context, onProfileEventListener, onChangeInputStateListener);
    }

    @Override
    protected void initInputView(Context context) {
        this.mobileNumberProfileInputView = new MobileNumberProfileInputView(context);
        this.overrideInputView((View)this.mobileNumberProfileInputView);
    }

    @Override
    protected void initInputViewEventListener() {
        this.mobileNumberProfileInputView.setEditTextChangedListener(new EditTextChangedListener(){

            @Override
            public void onWatchedTextChanged(String text) {
                if (text.contains(" ")) {
                    text = text.replace(" ", "");
                    MobileNumberProfileMessageView.this.mobileNumberProfileInputView.setText(text);
                }
                if (MobileNumberProfileMessageView.this.hasEditTextFocus) {
                    MobileNumberProfileMessageView.this.onChangeInputStateListener.onUpdateInputState(MobileNumberProfileMessageView.this.key, MobileNumberProfileMessageView.this.mobileNumberProfileInputView.getMobileNumber(), !text.isEmpty());
                }
                MobileNumberProfileMessageView.this.setStyle(false, MobileNumberProfileMessageView.this.mobileNumberProfileInputView.isInputFocused(), MobileNumberProfileMessageView.this.isValidInputState(MobileNumberProfileMessageView.this.mobileNumberProfileInputView.getMobileNumber()), MobileNumberProfileMessageView.this.isLoading);
            }
        });
        this.mobileNumberProfileInputView.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                MobileNumberProfileMessageView.this.hasEditTextFocus = hasFocus;
                MobileNumberProfileMessageView.this.setStyle(MobileNumberProfileMessageView.this.hasError, hasFocus, MobileNumberProfileMessageView.this.isValidInputState(MobileNumberProfileMessageView.this.mobileNumberProfileInputView.getMobileNumber()), MobileNumberProfileMessageView.this.isLoading);
                MobileNumberProfileMessageView.this.onProfileEventListener.onChangeFocus(hasFocus);
            }
        });
        this.mobileNumberProfileInputView.setOnCountryCodeSelectorClickListener(new OnCountryCodeSelectorClickListener(){

            @Override
            public void onClick(MobileNumber mobileNumber) {
                if (!MobileNumberProfileMessageView.this.isLoading && MobileNumberProfileMessageView.this.onProfileEventListener != null) {
                    MobileNumberProfileMessageView.this.onProfileEventListener.onCountryCodeClick(MobileNumberProfileMessageView.this.key, mobileNumber);
                }
            }
        });
        this.mobileNumberProfileInputView.setOnEditorActionListener(new TextView.OnEditorActionListener(){

            public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
                if (actionId == 6 || actionId == 5) {
                    if (MobileNumberProfileMessageView.this.isValidInputState(MobileNumberProfileMessageView.this.getValue())) {
                        MobileNumberProfileMessageView.this.onProfileEventListener.onSendButtonClick(MobileNumberProfileMessageView.this.key, MobileNumberProfileMessageView.this.getValue(), MobileNumberProfileMessageView.this.getInputState());
                    }
                    return true;
                }
                return false;
            }
        });
    }

    @Override
    protected boolean isInputViewFocused() {
        return this.mobileNumberProfileInputView.isInputFocused();
    }

    @Override
    protected void requestFocusInputView() {
        this.mobileNumberProfileInputView.requestFocusInputView();
    }

    @Override
    protected void setInputState(Object inputState, boolean isLoading, boolean isLastProfile) {
        if (inputState != null) {
            MobileNumber mobileNumber;
            if (inputState instanceof MobileNumber) {
                mobileNumber = (MobileNumber)inputState;
                this.mobileNumberProfileInputView.setMobileNumber(mobileNumber.getCountryCode(), mobileNumber.getPhoneNumber());
                this.mobileNumberProfileInputView.setSelection(mobileNumber.getPhoneNumber().length());
            }
            if (inputState instanceof String) {
                mobileNumber = this.parsePhoneNumber((String)inputState);
                this.mobileNumberProfileInputView.setMobileNumber(mobileNumber.getCountryCode(), mobileNumber.getPhoneNumber());
                this.mobileNumberProfileInputView.setSelection(mobileNumber.getPhoneNumber().length());
            }
            this.mobileNumberProfileInputView.setEnabled(!isLoading);
        }
        this.mobileNumberProfileInputView.setImeOption(isLastProfile ? 6 : 5);
    }

    private MobileNumber parsePhoneNumber(String value) {
        PhoneNumberUtil phoneUtil = PhoneNumberUtil.getInstance();
        try {
            Phonenumber.PhoneNumber numberProto = phoneUtil.parse(value, "");
            return new MobileNumber(numberProto.getCountryCode(), phoneUtil.format(numberProto, PhoneNumberUtil.PhoneNumberFormat.NATIONAL));
        }
        catch (NumberParseException e) {
            return new MobileNumber(CountryUtils.getDefaultCountryCodeInt(), "");
        }
    }

    @Override
    protected Object getValue() {
        MobileNumber mobileNumber = this.mobileNumberProfileInputView.getMobileNumber();
        return String.format("+%s%s", mobileNumber.getCountryCode(), mobileNumber.getPhoneNumber()).replace("-", "");
    }

    @Override
    protected Object getInputState() {
        return this.mobileNumberProfileInputView.getMobileNumber();
    }

    @Override
    protected boolean isValidInputState(Object value) {
        if (value != null) {
            if (value instanceof MobileNumber) {
                return !TextUtils.isEmpty((CharSequence)((MobileNumber)value).getPhoneNumber());
            }
            if (value instanceof String) {
                MobileNumber mobileNumber = this.parsePhoneNumber((String)value);
                return !TextUtils.isEmpty((CharSequence)mobileNumber.getPhoneNumber());
            }
        }
        return false;
    }

    @Override
    protected String getFormattedString(Object object) {
        PhoneNumberUtil phoneUtil = PhoneNumberUtil.getInstance();
        try {
            Phonenumber.PhoneNumber numberProto = phoneUtil.parse(object.toString(), "");
            return phoneUtil.format(numberProto, PhoneNumberUtil.PhoneNumberFormat.INTERNATIONAL);
        }
        catch (NumberParseException e) {
            return object == null ? "" : object.toString();
        }
    }
}

