package com.zoyi.channel.plugin.android.activity.userchat_list;

import com.zoyi.channel.plugin.android.activity.base.BaseDictionary;
import com.zoyi.channel.plugin.android.model.rest.Bot;
import com.zoyi.channel.plugin.android.model.interfaces.ChannelModel;
import com.zoyi.channel.plugin.android.model.rest.Manager;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.Session;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by mika on 2016. 12. 16..
 */
public class UserChatListDataDictionary extends BaseDictionary {

  private static UserChatListDataDictionary instance;
  public static UserChatListDataDictionary getInstance() {
    if (instance == null) {
      synchronized (UserChatListDataDictionary.class) {
        if (instance == null) {
          instance = new UserChatListDataDictionary();
        }
      }
    }
    return instance;
  }

  private Map<String, Session> sessionMap;
  private Map<String, Message> messageMap;

  private UserChatListDataDictionary() {
    super();
    sessionMap = new HashMap<>();
    messageMap = new HashMap<>();
  }

  @Override
  public void release() {
    super.release();
    if (sessionMap != null) {
      sessionMap.clear();
    }
    if (messageMap != null) {
      messageMap.clear();
    }
  }

  public <E extends ChannelModel> E get(Class<E> clazz, String id) {
    if (id != null) {
      String className = clazz.getSimpleName();
      switch (className) {
        case Manager.CLASSNAME:
          return (E) managerMap.get(id);

        case Bot.CLASSNAME:
          return (E) botMap.get(id);

        case Session.CLASSNAME:
          return (E) sessionMap.get(id);

        case Message.CLASSNAME:
          return (E) messageMap.get(id);
      }
    }
    return null;
  }

  public void add(List<? extends ChannelModel> channelModels) {
    if (channelModels != null) {
      for (ChannelModel channelModel : channelModels) {
        if (checkCanUpdate(channelModel)) {
          String className = channelModel.getClass().getSimpleName();
          switch (className) {
            case Manager.CLASSNAME:
              managerMap.put(channelModel.getId(), (Manager) channelModel);
              break;

            case Bot.CLASSNAME:
              botMap.put(channelModel.getId(), (Bot) channelModel);
              break;

            case Session.CLASSNAME:
              sessionMap.put(channelModel.getId(), (Session) channelModel);
              break;

            case Message.CLASSNAME:
              messageMap.put(channelModel.getId(), (Message) channelModel);
              break;
          }
        }
      }
    }
  }

  public void remove(ChannelModel channelModel) {
    String className = channelModel.getClass().getSimpleName();
    switch (className) {
      case Manager.CLASSNAME:
        if (managerMap.containsKey(channelModel.getId())) {
          managerMap.remove(channelModel.getId());
        }
        break;

      case Session.CLASSNAME:
        if (sessionMap.containsKey(channelModel.getId())) {
          sessionMap.remove(channelModel.getId());
        }
        break;

      case Message.CLASSNAME:
        if (messageMap.containsKey(channelModel.getId())) {
          messageMap.remove(channelModel.getId());
        }
        break;
    }
  }
}
