package com.zoyi.channel.plugin.android.activity.chat;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.view.layout.CHTextView;

public class ChatCompltedFragment extends Fragment implements View.OnClickListener {

  private Context context;
  private View root;

  private CHTextView textMessage;
  private String message;

  @Nullable
  @Override
  public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
    return inflater.inflate(R.layout.ch_plugin_fragment_chat_complted, container, false);
  }

  @Override
  public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
    super.onViewCreated(view, savedInstanceState);

    context = getActivity();
    root = view;
    textMessage =  view.findViewById(R.id.tv_completed_chat_message);
    view.findViewById(R.id.tv_new_user_chat).setOnClickListener(this);
  }

  @Override
  public void onClick(View v) {
    if (v.getId() == R.id.tv_new_user_chat) {
      ChatActivity activity = (ChatActivity) getActivity();

      if (activity != null) {
        PrefSupervisor.storeMessage(context, message);

        activity.setResult(Const.RESULT_CHAT_OPEN_NEW_CHAT);
        activity.finish();
      }
    }
  }

  public void show(String message) {
    if (TextUtils.isEmpty(message)) {
      textMessage.setTextByKey("ch.message_input.placeholder.disabled");
    } else {
      this.message = message;
      textMessage.setText(message);
    }
    root.setVisibility(View.VISIBLE);
  }

  public void hide() {
    root.setVisibility(View.GONE);
  }
}
