/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnSendingMessageClickListener;
import com.zoyi.channel.plugin.android.activity.chat.model.SendingMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.BaseMessageHolder;
import com.zoyi.channel.plugin.android.util.UIUtils;
import com.zoyi.channel.plugin.android.view.layout.CHTextView;
import com.zoyi.channel.plugin.android.view.layout.MaskableFrameLayout;
import com.zoyi.com.bumptech.glide.BitmapRequestBuilder;
import com.zoyi.com.bumptech.glide.Glide;

public class SendingMessageHolder
extends BaseMessageHolder
implements View.OnClickListener {
    View root;
    View resendLocalContentButton;
    View localTextLayout;
    View localTextContentLayout;
    View localTextContentBackground;
    CHTextView localMessageText;
    View localImageLayout;
    MaskableFrameLayout localImageLoadingLayout;
    ImageView imagePlaceholder;
    ImageView imageLoading;
    View localImageProgressView;
    View localImageUploadFailedView;
    private OnSendingMessageClickListener listener;
    private SendingMessageItem item;

    public static SendingMessageHolder newInstance(ViewGroup parent, MessageType messageType, OnSendingMessageClickListener listener) {
        return new SendingMessageHolder(SendingMessageHolder.getItemView(parent, messageType), messageType, listener);
    }

    public SendingMessageHolder(View itemView, MessageType messageType, OnSendingMessageClickListener listener) {
        super(itemView, messageType);
        this.listener = listener;
        this.root = itemView.findViewById(R.id.ch_message_content_loading);
        this.localMessageText = (CHTextView)itemView.findViewById(R.id.ch_text_local_message);
        this.localTextLayout = itemView.findViewById(R.id.ch_layout_local_message_text);
        this.localTextContentLayout = itemView.findViewById(R.id.ch_layout_local_message_content);
        this.localTextContentBackground = itemView.findViewById(R.id.ch_view_local_message_content_top);
        this.imagePlaceholder = (ImageView)itemView.findViewById(R.id.image_placeholder);
        this.imageLoading = (ImageView)itemView.findViewById(R.id.image_loading);
        this.localImageLayout = itemView.findViewById(R.id.ch_layout_local_message_image_content);
        this.localImageLoadingLayout = (MaskableFrameLayout)itemView.findViewById(R.id.ch_layout_local_message_image);
        this.localImageProgressView = itemView.findViewById(R.id.progress_upload);
        this.localImageUploadFailedView = itemView.findViewById(R.id.image_upload_failed);
        this.resendLocalContentButton = itemView.findViewById(R.id.ch_button_local_message_resend);
        this.resendLocalContentButton.setOnClickListener((View.OnClickListener)this);
    }

    public void bind(SendingMessageItem item, int messageColor, int messageBackgroundColor) {
        super.bind(null, item.getType(), true);
        this.item = item;
        this.root.setVisibility(0);
        this.guestMessageTextLayout.setVisibility(8);
        this.guestMessageTime.setVisibility(8);
        this.localImageLayout.setVisibility(8);
        this.localTextLayout.setVisibility(8);
        this.resendLocalContentButton.setVisibility(UIUtils.getVisible(!item.isSending(), true));
        if (item.isImage()) {
            this.setLocalImageMessage(item);
        } else {
            this.setLocalTextMessage(item, messageColor, messageBackgroundColor);
        }
    }

    private void setLocalImageMessage(SendingMessageItem item) {
        ((BitmapRequestBuilder)((BitmapRequestBuilder)Glide.with(this.itemView.getContext()).load(item.getString()).asBitmap().dontAnimate()).centerCrop()).into(this.imageLoading);
        this.imagePlaceholder.setVisibility(8);
        this.localImageLayout.setVisibility(0);
        this.localImageLoadingLayout.setVisibility(0);
        this.localImageProgressView.setVisibility(UIUtils.getVisible(item.isSending(), true));
        this.localImageUploadFailedView.setVisibility(UIUtils.getVisible(!item.isSending(), true));
    }

    private void setLocalTextMessage(SendingMessageItem item, int messageColor, int messageBackgroundColor) {
        this.localTextLayout.setVisibility(0);
        this.localMessageText.setText(item.getString());
        this.localMessageText.setTextColor(messageColor);
        this.localMessageText.setBackgroundColor(messageBackgroundColor);
        this.localTextContentBackground.setBackgroundColor(messageBackgroundColor);
    }

    public void onClick(View v) {
        if (this.listener != null && this.item != null) {
            this.listener.sendingMessageClicked(this.item);
        }
    }
}

