/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.content.Context;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.RecyclerView;
import android.text.SpannableString;
import android.view.View;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.model.LogMessageItem;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.TextDecorator;
import com.zoyi.channel.plugin.android.view.layout.CHTextView;

public class LogMessageHolder
extends RecyclerView.ViewHolder {
    private Context context;
    private View root;
    private CHTextView textLog;
    private int datetimeSize;

    public LogMessageHolder(View itemView) {
        super(itemView);
        this.context = itemView.getContext();
        this.root = itemView;
        this.textLog = (CHTextView)itemView.findViewById(R.id.text_log);
        this.datetimeSize = (int)this.context.getResources().getDimension(R.dimen.ch_log_message_date_text_size);
    }

    public void bind(LogMessageItem item) {
        if (item != null && item.isLogResolve()) {
            String messageTime = item.getCreatedTime();
            SpannableString result = new SpannableString((CharSequence)String.format("%s  %s", ResUtils.getString(this.context, "ch.log.resolved"), messageTime));
            result = TextDecorator.color(result, messageTime, ContextCompat.getColor((Context)this.context, (int)R.color.ch_light));
            result = TextDecorator.size(result, messageTime, this.datetimeSize);
            this.textLog.setText((CharSequence)result);
            this.root.setVisibility(0);
        } else {
            this.root.setVisibility(8);
        }
    }
}

