package com.zoyi.channel.plugin.android;

import java.util.HashMap;
import java.util.Map;

public class Profile {
  private String userId;
  private String name;
  private String avatarUrl;
  private String mobileNumber;
  private Map<String, Object> property;

  public static Profile create() {
    return new Profile();
  }
  private Profile() {
    property = new HashMap<>();
  }

  public String getUserId() {
    return userId;
  }

  public String getName() {
    return name;
  }

  public String getMobileNumber() {
    return mobileNumber;
  }

  public String getAvatarUrl() {
    return avatarUrl;
  }

  public Map<String, Object> getProperty() {
    return property;
  }

  public Profile setUserId(String userId) {
    this.userId = userId;
    return this;
  }

  public Profile setName(String name) {
    this.name = name;
    return this;
  }

  public Profile setMobileNumber(String mobileNumber) {
    this.mobileNumber = mobileNumber;
    return this;
  }

  public Profile setAvatarUrl(String avatarUrl) {
    this.avatarUrl = avatarUrl;
    return this;
  }

  public Profile setProperty(String propertyKey, Object propertyValue) {
    this.property.put(propertyKey, propertyValue);
    return this;
  }
}
