package com.zoyi.channel.plugin.android;

import java.util.HashMap;
import java.util.Map;

public class Guest {
  private String id;
  private String name;
  private String avatarUrl;
  private String mobileNumber;
  private Map<String, Object> property;

  public static Guest create() {
    return new Guest();
  }
  private Guest() {
    property = new HashMap<>();
  }

  public String getId() {
    return id;
  }

  public String getName() {
    return name;
  }

  public String getMobileNumber() {
    return mobileNumber;
  }

  public String getAvatarUrl() {
    return avatarUrl;
  }

  public Map<String, Object> getProperty() {
    return property;
  }

  public Guest setId(String id) {
    this.id = id;
    return this;
  }

  public Guest setName(String name) {
    this.name = name;
    return this;
  }

  public Guest setMobileNumber(String mobileNumber) {
    this.mobileNumber = mobileNumber;
    return this;
  }

  public Guest setAvatarUrl(String avatarUrl) {
    this.avatarUrl = avatarUrl;
    return this;
  }

  public Guest setProperty(String propertyKey, Object propertyValue) {
    this.property.put(propertyKey, propertyValue);
    return this;
  }
}
