/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.model.source.userchat;

import com.zoyi.channel.plugin.android.activity.base.SortedItem;
import com.zoyi.channel.plugin.android.activity.userchat_list.UserChatListDataDictionary;
import com.zoyi.channel.plugin.android.model.interfaces.ProfileEntity;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.Session;
import com.zoyi.channel.plugin.android.model.rest.UserChat;

public class UserChatItem
implements SortedItem {
    private UserChatListDataDictionary dictionary;
    private UserChat userChat;
    private Session session;
    private Message message;

    public UserChatItem(UserChat userChat, UserChatListDataDictionary dictionary) {
        this.userChat = userChat;
        this.dictionary = dictionary;
        this.session = dictionary.get(Session.class, userChat.getSessionId());
        this.message = dictionary.get(Message.class, userChat.getLastMessageId());
    }

    public void setUserChat(UserChat userChat) {
        this.userChat = userChat;
        this.session = this.dictionary.get(Session.class, userChat.getSessionId());
        this.message = this.dictionary.get(Message.class, userChat.getLastMessageId());
    }

    public String getId() {
        if (this.userChat != null) {
            return this.userChat.getId();
        }
        return "";
    }

    public ProfileEntity getProfile() {
        return this.dictionary.getProfile(this.userChat.getHostType(), this.userChat.getHostId());
    }

    public UserChat getUserChat() {
        return this.userChat;
    }

    public String getSessionId() {
        if (this.userChat != null) {
            return this.userChat.getSessionId();
        }
        return "";
    }

    public Session getSession() {
        return this.session;
    }

    public Message getMessage() {
        return this.message;
    }

    @Override
    public Long getFirst() {
        if (this.message != null) {
            return this.message.getCreatedAt();
        }
        return 0L;
    }

    @Override
    public String getSecond() {
        if (this.userChat != null) {
            return this.userChat.getId();
        }
        return "";
    }

    public void setSession(Session session) {
        this.session = session;
    }
}

