/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android;

import android.app.Application;
import android.content.Context;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import android.text.TextUtils;
import com.splunk.mint.Mint;
import com.zoyi.channel.plugin.android.ActivityLifecycleManager;
import com.zoyi.channel.plugin.android.ChannelPluginCompletionStatus;
import com.zoyi.channel.plugin.android.ChannelPluginListener;
import com.zoyi.channel.plugin.android.ChannelPluginSettings;
import com.zoyi.channel.plugin.android.ChannelStore;
import com.zoyi.channel.plugin.android.Guest;
import com.zoyi.channel.plugin.android.OnBootListener;
import com.zoyi.channel.plugin.android.OnGuestUpdatedListener;
import com.zoyi.channel.plugin.android.activity.chat.ChatActivity;
import com.zoyi.channel.plugin.android.activity.chat.ChatManager;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnChatListener;
import com.zoyi.channel.plugin.android.activity.userchat_list.UserChatListActivity;
import com.zoyi.channel.plugin.android.enumerate.Command;
import com.zoyi.channel.plugin.android.event.CommandBus;
import com.zoyi.channel.plugin.android.event.LauncherBus;
import com.zoyi.channel.plugin.android.event.RxBus;
import com.zoyi.channel.plugin.android.global.CheckInPrefSupervisor;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.Event;
import com.zoyi.channel.plugin.android.model.wrapper.PackageWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.PluginWrapper;
import com.zoyi.channel.plugin.android.network.ChannelApi;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.channel.plugin.android.network.RetrofitException;
import com.zoyi.channel.plugin.android.network.ServiceFactory;
import com.zoyi.channel.plugin.android.push.ChannelPushClient;
import com.zoyi.channel.plugin.android.push.ChannelPushManager;
import com.zoyi.channel.plugin.android.socket.SocketManager;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import com.zoyi.channel.plugin.android.util.IntentUtils;
import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.channel.plugin.android.util.RequestUtils;
import com.zoyi.okhttp3.RequestBody;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.android.schedulers.AndroidSchedulers;
import com.zoyi.rx.schedulers.Schedulers;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;

public class ChannelIO {
    private static final String MINT_DEBUG_KEY = "e72f17f4";
    private static final String MINT_PROD_KEY = "22464da6";
    private static boolean isDebugMode = false;
    private static boolean isEnabledTrackDefaultEvent = true;
    private static boolean isHideDefaultInAppPush = true;
    private static ChannelIO channelIO;
    private static ChannelApi channelApi;
    private static OnChatListener onChatListener;
    private Application application;
    private Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
    private AtomicInteger checkInCounter = new AtomicInteger(0);
    private ActivityLifecycleManager activityLifecycleManager;

    private ChannelIO(Application application) {
        if (ChannelIO.isInitializedChannelIO()) {
            L.e("Channel plugin already initialized");
            return;
        }
        if (application == null) {
            L.e("Application cannot be null");
            return;
        }
        this.application = application;
        this.activityLifecycleManager = new ActivityLifecycleManager();
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.activityLifecycleManager);
        this.setUncaughtExceptionHandler();
        ChannelStore.create(application);
        SocketManager.create(application);
    }

    public static void initialize(@NonNull Application application) {
        channelIO = new ChannelIO(application);
    }

    public static void boot(ChannelPluginSettings pluginSettings) {
        ChannelIO.boot(pluginSettings, null, null);
    }

    public static void boot(ChannelPluginSettings pluginSettings, OnBootListener completion) {
        ChannelIO.boot(pluginSettings, null, completion);
    }

    public static void boot(ChannelPluginSettings pluginSettings, Guest guest) {
        ChannelIO.boot(pluginSettings, guest, null);
    }

    public static void boot(ChannelPluginSettings pluginSettings, Guest guest, OnBootListener completion) {
        if (ChannelIO.isInitializedChannelIO() && pluginSettings != null && pluginSettings.getPluginKey() != null) {
            channelIO.setChannelInfo(pluginSettings);
            channelIO.checkIn(pluginSettings, guest, completion);
        } else {
            L.e("Check plugin information");
        }
    }

    public static void shutdown() {
        if (ChannelIO.isInitializedChannelIO()) {
            channelIO.checkOutProcess();
        }
    }

    public static boolean open(@NonNull Context context) {
        if (!ChannelIO.isInitializedChannelIO() || !ChannelIO.isDataStored()) {
            L.e("Please check in first");
            return false;
        }
        for (ChannelPluginListener l : ChannelStore.getChannelPluginListeners()) {
            if (l == null) continue;
            l.willShowMessenger();
        }
        if (ChannelIO.isEnabledTrackDefaultEvent() && ChannelStore.getPluginKey() != null) {
            ChannelIO.track(context, ChannelStore.getPluginKey(), "ChannelOpen", null);
        }
        IntentUtils.setNextActivity(context, UserChatListActivity.class).startActivity();
        return true;
    }

    public static void close() {
        if (ChannelIO.isInitializedChannelIO()) {
            channelIO.finishAll();
        }
    }

    public static void show() {
        RxBus.post(new LauncherBus(true));
    }

    public static void hide() {
        RxBus.post(new LauncherBus(false));
    }

    public static boolean openChat(@NonNull Context context) {
        return ChannelIO.openChat(context, null);
    }

    public static boolean openChat(@NonNull Context context, @Nullable String chatId) {
        if (!ChannelIO.isInitializedChannelIO() || !ChannelIO.isDataStored()) {
            L.e("Please Boot first");
            return false;
        }
        if (ChannelIO.isEnabledTrackDefaultEvent() && ChannelStore.getPluginKey() != null) {
            ChannelIO.track(context, ChannelStore.getPluginKey(), "ChannelOpen", null);
        }
        IntentUtils.setNextActivity(context, ChatActivity.class).putExtra("chatCount", 0).putExtra("firstChat", chatId == null).putExtra("chatId", chatId).startActivityForResult(21);
        return true;
    }

    public static void handlePushNotification(Context context) {
        ChannelPushClient.handlePushNotification(context);
    }

    public static void showPushNotification(Context context, Map<String, String> message) {
        ChannelPushManager.showPushNotification(context, message);
    }

    public static boolean isChannelPushNotification(Map<String, String> message) {
        return ChannelPushManager.isChannelPushNotification(message);
    }

    private void setUncaughtExceptionHandler() {
        this.uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable ex) {
                if (Looper.getMainLooper().getThread() == thread) {
                    ChannelIO.this.uncaughtExceptionHandler.uncaughtException(thread, ex);
                } else if (ex instanceof RejectedExecutionException) {
                    SocketManager.reconnect();
                }
            }
        });
    }

    private void setChannelInfo(ChannelPluginSettings pluginSettings) {
        isDebugMode = pluginSettings.isDebugMode();
        isEnabledTrackDefaultEvent = pluginSettings.isEnabledTrackDefaultEvent();
        isHideDefaultInAppPush = pluginSettings.isHideDefaultInAppPush();
        ChannelStore.setPluginKey(pluginSettings.getPluginKey());
        PrefSupervisor.setPluginSetting((Context)ChannelIO.channelIO.application, pluginSettings);
    }

    private void checkIn(ChannelPluginSettings pluginSettings, Guest guest, OnBootListener listener) {
        if (ChannelIO.isDataStored()) {
            this.checkOutProcess();
        }
        channelIO.checkVersion(pluginSettings, guest, listener);
    }

    private void checkVersion(final ChannelPluginSettings pluginSettings, final Guest guest, final OnBootListener listener) {
        final int counter = this.checkInCounter.incrementAndGet();
        ChannelIO.getApi().getLastestPackage("com.zoyi.channel.plugin.android", "3.0.1").subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new RestSubscriber<PackageWrapper>(){

            @Override
            public void onError(Throwable error) {
                if (counter != ChannelIO.this.checkInCounter.get()) {
                    return;
                }
                if (listener != null) {
                    listener.onCompletion(ChannelPluginCompletionStatus.NETWORK_TIMEOUT);
                }
            }

            @Override
            public void onNext(PackageWrapper wrapper) {
                if (counter != ChannelIO.this.checkInCounter.get()) {
                    return;
                }
                if (!wrapper.isNeedToUpgrade()) {
                    if (!CompareUtils.isSame(wrapper.getVersionString(), "3.0.1")) {
                        L.i("Newest version is: " + wrapper.getVersionString());
                    }
                    ChannelIO.this.checkInProcess(pluginSettings, guest, listener, counter);
                } else if (listener != null) {
                    listener.onCompletion(ChannelPluginCompletionStatus.NOT_AVAILABLE_VERSION);
                }
            }
        });
    }

    private void checkInProcess(final ChannelPluginSettings pluginSettings, final Guest guest, final OnBootListener listener, final int counter) {
        HashMap<String, Object> form = new HashMap<String, Object>();
        if (guest != null) {
            form.put("name", guest.getName());
            form.put("avatarUrl", guest.getAvatarUrl());
            form.put("mobileNumber", guest.getMobileNumber());
            form.put("meta", guest.getProperty());
        }
        RequestBody body = RequestUtils.form(form).create();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (guest != null && guest.getId() != null) {
            headers.put("X-User-Id", guest.getId());
        }
        if (PrefSupervisor.getVeilId((Context)this.application) != null) {
            headers.put("X-Veil-Id", PrefSupervisor.getVeilId((Context)this.application));
        }
        ChannelIO.getApi().checkIn(headers, pluginSettings.getPluginKey(), null, body).subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new RestSubscriber<PluginWrapper>(){

            @Override
            public void onError(Throwable e) {
                if (counter != ChannelIO.this.checkInCounter.get()) {
                    return;
                }
                L.e(e.getMessage());
                if (listener != null) {
                    ChannelPluginCompletionStatus status = ChannelPluginCompletionStatus.UNKNOWN_ERROR;
                    if (e instanceof RetrofitException) {
                        switch (((RetrofitException)e).getKind()) {
                            case HTTP: {
                                status = ChannelPluginCompletionStatus.NOT_INITIALIZED;
                                break;
                            }
                            case NETWORK: {
                                status = ChannelPluginCompletionStatus.NETWORK_TIMEOUT;
                                break;
                            }
                            default: {
                                status = ChannelPluginCompletionStatus.UNKNOWN_ERROR;
                            }
                        }
                    }
                    listener.onCompletion(status);
                }
            }

            @Override
            public void onNext(PluginWrapper pluginWrapper) {
                if (counter == ChannelIO.this.checkInCounter.get() && !pluginWrapper.getChannel().isBlockedPlugin() && !pluginSettings.isHideDefaultLauncher()) {
                    if (guest == null) {
                        CheckInPrefSupervisor.setVeil((Context)ChannelIO.this.application, pluginWrapper.getVeil());
                    } else {
                        CheckInPrefSupervisor.setGuest((Context)ChannelIO.this.application, guest);
                    }
                    if (pluginSettings.isEnabledTrackDefaultEvent()) {
                        ChannelIO.track((Context)ChannelIO.this.application, pluginSettings.getPluginKey(), "Boot", null);
                    }
                    ChannelIO.this.initBugTracking(pluginWrapper.getChannel());
                    ChannelStore.checkIn(pluginWrapper);
                    ChannelPushManager.sendTokenToChannelIO((Context)ChannelIO.this.application);
                    SocketManager.setChannelId(pluginWrapper.getChannel().getId());
                    SocketManager.connect();
                    RxBus.post(new CommandBus(Command.CHECKED_IN, pluginWrapper.getPlugin()));
                    if (listener != null) {
                        listener.onCompletion(ChannelPluginCompletionStatus.SUCCESS);
                    }
                }
            }
        });
    }

    private void checkOutProcess() {
        this.checkInCounter.incrementAndGet();
        ChannelPushManager.deleteToken((Context)this.application);
        CheckInPrefSupervisor.clear((Context)this.application);
        ChannelStore.clear();
        RxBus.post(new CommandBus(Command.CHECKED_OUT));
        SocketManager.setChannelId(null);
        SocketManager.disconnect();
        ChatManager.release();
        this.releaseBugTracking();
    }

    private void finishAll() {
        if (this.activityLifecycleManager != null) {
            this.activityLifecycleManager.finish();
        }
    }

    public static ChannelApi getApi() {
        if (channelApi == null) {
            channelApi = ServiceFactory.create();
        }
        return channelApi;
    }

    private void initBugTracking(Channel channel) {
        if (this.application != null) {
            Mint.disableNetworkMonitoring();
            Mint.initAndStartSession((Application)this.application, (String)MINT_PROD_KEY);
            Mint.addExtraData((String)"plugin_version", (String)"3.0.1");
            if (channel != null) {
                Mint.addExtraData((String)"channel_id", (String)channel.getId());
                Mint.addExtraData((String)"channel_name", (String)channel.getName());
            }
        }
    }

    private void releaseBugTracking() {
        if (this.application != null) {
            Mint.clearExtraData();
            Mint.closeSession((Application)this.application);
            Mint.flush();
        }
    }

    public static void track(@NonNull Context context, @NonNull String pluginKey, @NonNull @Size(min=1L, max=30L) String eventName, @Nullable Map<String, Object> eventProperty) {
        if (TextUtils.isEmpty((CharSequence)eventName) || eventName.length() > 30) {
            return;
        }
        ChannelIO.track(new Event(context, pluginKey, eventName, eventProperty));
    }

    private static void track(@NonNull Event event) {
        ChannelIO.getApi().trackEvent(event).subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe(new RestSubscriber());
    }

    public static boolean isInitializedChannelIO() {
        return channelIO != null;
    }

    public static Context getAppContext() {
        if (channelIO != null) {
            return ChannelIO.channelIO.application.getApplicationContext();
        }
        return null;
    }

    public static boolean isDebugMode() {
        return isDebugMode;
    }

    public static boolean isEnabledTrackDefaultEvent() {
        return isEnabledTrackDefaultEvent;
    }

    public static boolean isHideInAppPush() {
        return isHideDefaultInAppPush;
    }

    public static boolean isDataStored() {
        return ChannelStore.isDataStored();
    }

    public static void updateGuest() {
        ChannelIO.updateGuest(null);
    }

    public static void updateGuest(OnGuestUpdatedListener listener) {
        ChannelStore.fetchMe(listener);
    }

    public static void addChannelPluginListener(ChannelPluginListener listener) {
        ChannelStore.addChannelPluginListener(listener);
    }

    public static void removeChannelPluginListener(ChannelPluginListener listener) {
        ChannelStore.removeChannelPluginListener(listener);
    }

    @Nullable
    public static OnChatListener getOnChatListener() {
        return onChatListener;
    }

    public static void setOnChatListener(@NonNull OnChatListener listener) {
        if (ChannelIO.isInitializedChannelIO()) {
            onChatListener = listener;
        }
    }

    static {
        onChatListener = null;
    }
}

