package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.LinearLayout;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnMessageClickListener;
import com.zoyi.channel.plugin.android.activity.chat.model.ChatMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.model.rest.File;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.PreviewThumb;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.view.layout.MaskableFrameLayout;
import com.zoyi.com.bumptech.glide.Glide;
import com.zoyi.com.bumptech.glide.request.RequestListener;
import com.zoyi.com.bumptech.glide.request.target.Target;

/**
 * Created by jerry on 2018. 3. 28..
 */

public class ImageMessageHolder extends TextMessageHolder implements View.OnClickListener {

  private Context context;

  MaskableFrameLayout imageLayout;
  ImageView imagePlaceholder;
  ImageView imageContent;

  private Point previewSize;
  private Message message;

  private OnMessageClickListener listener;

  public static ImageMessageHolder newInstance(
      ViewGroup parent,
      MessageType messageType,
      OnMessageClickListener listener) {
    return new ImageMessageHolder(getItemView(parent, messageType), messageType, listener);
  }

  public ImageMessageHolder(View itemView, MessageType messageType, OnMessageClickListener listener) {
    super(itemView, messageType);
    this.context = itemView.getContext();
    this.listener = listener;

    imageLayout = itemView.findViewById(R.id.ch_message_content_image);
    imagePlaceholder = itemView.findViewById(R.id.image_placeholder);
    imageContent = itemView.findViewById(R.id.image_chat);
  }

  public void bind(ChatMessageItem item, boolean isConnectedMessage) {
    super.bind(item, isConnectedMessage);

    message = item.getMessage();
    if (message != null) {
      File file = message.getFile();

      if (file != null) {
        setImageMessage(file.getPreviewThumb(), false, message.getMessage());
      }
    }
  }

  protected void setImageMessage(PreviewThumb previewThumb, boolean isWebPage, String message) {
    int width = 0, height = 0;
    previewSize = new Point();

    WindowManager wm = (WindowManager) context.getSystemService(Context.WINDOW_SERVICE);
    Point windowSize = new Point();
    wm.getDefaultDisplay().getSize(windowSize);

    if (isWebPage) {
      // 146 = margins' sum.
      width = windowSize.x - (int) Utils.dpToPx(context, 146);
      height = (int) (width * 0.52);

      previewSize.set(width, height);
    } else {
      previewSize = Utils.getCorrectImageSize(
          windowSize.x,
          windowSize.y,
          previewThumb.getWidth(),
          previewThumb.getHeight());
      width = Math.max(previewSize.x, 1);
      height = Math.max(previewSize.y, 1);
    }

    LinearLayout.LayoutParams params = (LinearLayout.LayoutParams) imageLayout.getLayoutParams();
    params.width = width;
    params.height = height;

    int marginTop = (int) Utils.dpToPx(context, !TextUtils.isEmpty(message) ? 10f : 0f);
    int marginBottom = (int) Utils.dpToPx(context, 4f);
    params.setMargins(0, marginTop, 0, marginBottom);

    imageLayout.setLayoutParams(params);
    imageLayout.setOnClickListener(this);
    imageLayout.setVisibility(View.VISIBLE);
    imagePlaceholder.setVisibility(View.VISIBLE);

    Glide.with(itemView.getContext())
        .load(previewThumb.getUrl())
        .asBitmap()
        .override(width, height)
        .dontAnimate()
        .centerCrop()
        .listener(new RequestListener<String, Bitmap>() {
          @Override
          public boolean onException(
              Exception e,
              String model,
              Target<Bitmap> target,
              boolean isFirstResource) {
            return false;
          }

          @Override
          public boolean onResourceReady(
              Bitmap resource,
              String model,
              Target<Bitmap> target,
              boolean isFromMemoryCache,
              boolean isFirstResource) {
            imagePlaceholder.setVisibility(View.GONE);
            return false;
          }
        })
        .into(imageContent);
  }

  protected Point getPreviewSize() {
    return previewSize;
  }

  @Override
  public void onClick(View v) {
    if (message != null) {
      listener.messageClicked(message);
    }
  }
}
