/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.push;

import android.content.Context;
import android.text.TextUtils;
import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.ChannelPluginCompletionStatus;
import com.zoyi.channel.plugin.android.ChannelPluginSettings;
import com.zoyi.channel.plugin.android.OnBootListener;
import com.zoyi.channel.plugin.android.activity.userchat_list.UserChatListActivity;
import com.zoyi.channel.plugin.android.global.CheckInPrefSupervisor;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.push.ChannelPushManager;
import com.zoyi.channel.plugin.android.util.IntentUtils;
import com.zoyi.channel.plugin.android.util.L;

public class ChannelPushClient {
    public static void handlePushNotification(final Context context) {
        ChannelPushManager.clearNotification(context);
        if (PrefSupervisor.hasPushChatId(context) && CheckInPrefSupervisor.hasCheckInData(context)) {
            if (ChannelIO.isDataStored()) {
                ChannelPushClient.launchChat(context);
            } else if (ChannelIO.isInitializedChannelIO()) {
                ChannelPluginSettings pluginSettings = PrefSupervisor.getPluginSetting(context);
                if (pluginSettings != null) {
                    ChannelIO.boot(pluginSettings, new OnBootListener(){

                        @Override
                        public void onCompletion(ChannelPluginCompletionStatus status) {
                            switch (status) {
                                case SUCCESS: {
                                    ChannelPushClient.launchChat(context);
                                    break;
                                }
                                case NOT_INITIALIZED: {
                                    L.e("Push Notification : This plugin is Not initialized");
                                    break;
                                }
                                case NETWORK_TIMEOUT: {
                                    L.e("Push Notification : Network timeout error!");
                                    break;
                                }
                                case INVALID_SETTINGS: {
                                    L.e("Push Notification : Check Plugin Settings");
                                    break;
                                }
                                case NOT_AVAILABLE_VERSION: {
                                    L.e("Push Notification : Check Plugin version");
                                    break;
                                }
                                case SERVICE_UNDER_CONSTRUCTION: {
                                    L.e("Push Notification : Service is now under construction");
                                    break;
                                }
                                default: {
                                    L.e("Push Notification : Unknown error");
                                }
                            }
                        }
                    });
                } else {
                    L.e("Push Notification : This plugin is Not initialized");
                }
            }
        }
    }

    private static void launchChat(Context context) {
        String chatId = PrefSupervisor.getPushChatId(context);
        if (!TextUtils.isEmpty((CharSequence)chatId)) {
            IntentUtils.setNextActivity(context, UserChatListActivity.class).putExtra("chatId", chatId).putExtra("push_click", true).startActivity();
        }
        PrefSupervisor.clearPushChatId(context);
    }
}

