package com.zoyi.channel.plugin.android.network;

import com.zoyi.channel.plugin.android.ChannelStore;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.okhttp3.Interceptor;
import com.zoyi.okhttp3.Request;
import com.zoyi.okhttp3.Response;

import java.io.IOException;
import java.util.Locale;

/**
 * Created by mika on 2016. 3. 14..
 */
public class RetrofitInterceptor implements Interceptor {
  @Override
  public Response intercept(Chain chain) throws IOException {
    Request request = chain.request();

    Request.Builder builder = request.newBuilder();
    builder = builder.header("Accept-Language", Locale.getDefault().getLanguage());

    if (ChannelStore.getVeilId() != null) {
      builder.header("X-Veil-Id", ChannelStore.getVeilId());
    }
    if (ChannelStore.getUserId() != null) {
      builder.header("X-User-Id", ChannelStore.getUserId());
    }

    Channel channel = ChannelStore.getChannel();
    if (channel != null && channel.getId() != null) {
      builder.header("X-Channel-Id", channel.getId());
    }
    return chain.proceed(builder.build());
  }
}
