package com.zoyi.channel.plugin.android.global;

import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.support.v4.content.FileProvider;

import java.io.File;

public class ChannelFileProvider extends FileProvider {

  public static Uri getUriForFile(Context context, File file) {
    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
      return FileProvider.getUriForFile(
          context,
          String.format("%s.ch_file_provider", context.getPackageName()),
          file);
    } else {
      return Uri.fromFile(file);
    }
  }

}
