/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.presenter.userchat;

import android.content.Context;
import android.text.TextUtils;
import com.zoyi.channel.plugin.android.ChannelPlugin;
import com.zoyi.channel.plugin.android.activity.userchat_list.OnUserChatClickListener;
import com.zoyi.channel.plugin.android.activity.userchat_list.UserChatCounter;
import com.zoyi.channel.plugin.android.activity.userchat_list.UserChatListDataDictionary;
import com.zoyi.channel.plugin.android.enumerate.Command;
import com.zoyi.channel.plugin.android.enumerate.userchat.UserChatListState;
import com.zoyi.channel.plugin.android.event.ChatCounterBus;
import com.zoyi.channel.plugin.android.event.RxBus;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.model.interfaces.ChannelModel;
import com.zoyi.channel.plugin.android.model.rest.Manager;
import com.zoyi.channel.plugin.android.model.rest.Session;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.model.source.userchat.UserChatDataSource;
import com.zoyi.channel.plugin.android.model.source.userchat.UserChatRepository;
import com.zoyi.channel.plugin.android.model.wrapper.UserChatsWrapper;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.channel.plugin.android.network.RetrofitException;
import com.zoyi.channel.plugin.android.presenter.userchat.UserChatAdapterContract;
import com.zoyi.channel.plugin.android.presenter.userchat.UserChatContract;
import com.zoyi.channel.plugin.android.socket.SocketManager;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.android.schedulers.AndroidSchedulers;
import com.zoyi.rx.schedulers.Schedulers;

public class UserChatPresenter
implements UserChatContract.Presenter,
OnUserChatClickListener {
    private UserChatContract.View view;
    private UserChatAdapterContract.View adapterView;
    private UserChatAdapterContract.Model adapterModel;
    private UserChatRepository userChatRepository;
    private Context context;
    private UserChatListDataDictionary dictionary;
    private UserChatCounter userChatCounter;
    private UserChatListState state = UserChatListState.WAITING_SOCKET;
    private boolean init = true;
    private String runningChatId;

    public UserChatPresenter(Context context) {
        this.context = context;
        this.dictionary = UserChatListDataDictionary.getInstance();
        this.userChatRepository = new UserChatRepository(new UserChatDataSource());
        this.userChatCounter = new UserChatCounter();
    }

    @Override
    public void setView(UserChatContract.View view) {
        this.view = view;
    }

    @Override
    public void setAdapterView(UserChatAdapterContract.View adapterView) {
        this.adapterView = adapterView;
        this.adapterView.setOnUserChatClickListener(this);
    }

    @Override
    public void setAdapterModel(UserChatAdapterContract.Model adapterModel) {
        this.adapterModel = adapterModel;
    }

    @Override
    public void release() {
        if (this.dictionary != null) {
            this.dictionary.release();
        }
        this.dictionary = null;
    }

    @Override
    public void setRunningChatId(String runningChatId) {
        this.runningChatId = runningChatId;
    }

    @Override
    public void setInit(boolean init) {
        this.init = init;
    }

    @Override
    public int getChatCount(String chatId) {
        return this.userChatCounter.getCounter(chatId);
    }

    @Override
    public void refresh() {
        switch (this.state) {
            case WAITING_SOCKET: {
                SocketManager.connect();
                break;
            }
            case USER_CHAT_LIST_NOT_LOADED: {
                this.getUserChats();
            }
        }
    }

    @Override
    public void setState(UserChatListState state) {
        this.state = state;
    }

    @Override
    public void getUserChats() {
        if (SocketManager.isReady()) {
            if (this.init) {
                this.view.showProgress(ResUtils.getString(this.context, "ch.loading_information"));
                this.dictionary.release();
                this.adapterModel.clear();
            }
            this.view.setReconnectVisibility(false);
            this.setState(UserChatListState.USER_CHAT_LIST_LOADING);
            this.view.setRefreshVisibility(false);
            this.fetchUserChats();
        } else {
            this.setState(UserChatListState.WAITING_SOCKET);
            this.view.setRefreshVisibility(false);
            SocketManager.reconnect();
        }
    }

    @Override
    public void receiveCommand(Command command, Object object) {
        switch (command) {
            case READY: {
                this.view.setReconnectVisibility(false);
                if (UserChatListState.WAITING_SOCKET.equals((Object)this.state)) {
                    this.getUserChats();
                    break;
                }
                this.refresh();
                break;
            }
            case JOINED: {
                this.runningChatId = (String)object;
                break;
            }
            case SOCKET_DISCONNECTED: {
                this.setState(UserChatListState.WAITING_SOCKET);
                this.view.setRefreshVisibility(true);
                this.adapterModel.stopRefreshBySocket();
                break;
            }
            case SOCKET_ERROR: {
                this.view.setReconnectVisibility(true);
            }
        }
    }

    @Override
    public void receiveData(ChannelModel channelModel, boolean upsert) {
        if (channelModel == null) {
            return;
        }
        if (upsert) {
            this.dictionary.add(channelModel);
        } else {
            this.dictionary.remove(channelModel);
        }
        if (channelModel instanceof UserChat) {
            this.updateUserChat((UserChat)channelModel);
        } else if (channelModel instanceof Session) {
            this.updateSession((Session)channelModel, upsert);
        } else if (channelModel instanceof Manager) {
            this.adapterModel.updateManager(channelModel.getId());
        }
    }

    private void updateUserChat(UserChat userChat) {
        boolean isShowClosedChat = PrefSupervisor.isShownClosedChat(this.context);
        String userChatId = userChat.getId();
        if (TextUtils.isEmpty((CharSequence)userChat.getLastMessageId())) {
            return;
        }
        if (userChat.isStateRemoved()) {
            this.userChatCounter.delete(userChatId);
            this.adapterModel.removeItem(userChat);
            return;
        }
        if (userChat.isStateClosed()) {
            if (isShowClosedChat) {
                this.adapterModel.addOrUpdateItem(userChat);
            } else {
                this.userChatCounter.delete(userChatId);
                this.adapterModel.removeItem(userChat);
            }
        } else {
            this.adapterModel.addOrUpdateItem(userChat);
        }
    }

    private void updateSession(Session session, boolean upsert) {
        this.adapterModel.updateSession(session);
        if (!CompareUtils.exists((Comparable)((Object)session.getPersonType()), (Comparable[])new String[]{"User", "Veil"})) {
            return;
        }
        if (upsert) {
            this.userChatCounter.upsert(session);
        } else {
            this.userChatCounter.delete(session.getChatId());
        }
        if (session.getId() != null && !CompareUtils.isSame(session.getChatId(), this.runningChatId)) {
            RxBus.post(new ChatCounterBus(this.userChatCounter.getCounter(this.runningChatId)));
        }
    }

    private void fetchUserChats() {
        String[] states = PrefSupervisor.isShownClosedChat(this.context) ? "ready&open&following&resolved&closed".split("&") : "ready&open&following&resolved".split("&");
        this.userChatRepository.getUserChats(new RestSubscriber<UserChatsWrapper>(){

            @Override
            public void onError(RetrofitException error) {
                UserChatPresenter.this.view.hideProgress();
                UserChatPresenter.this.handleError();
            }

            @Override
            public void onNext(UserChatsWrapper userChatsWrapper) {
                UserChatPresenter.this.view.hideProgress();
                if (userChatsWrapper == null) {
                    UserChatPresenter.this.handleError();
                } else {
                    UserChatPresenter.this.init = false;
                    UserChatPresenter.this.dictionary.add(userChatsWrapper.getManagers());
                    UserChatPresenter.this.dictionary.add(userChatsWrapper.getBots());
                    UserChatPresenter.this.dictionary.add(userChatsWrapper.getSessions());
                    UserChatPresenter.this.dictionary.add(userChatsWrapper.getMessages());
                    UserChatPresenter.this.setState(UserChatListState.READY);
                    UserChatPresenter.this.view.setRefreshVisibility(false);
                    UserChatPresenter.this.adapterModel.init(userChatsWrapper);
                    UserChatPresenter.this.userChatCounter.setList(userChatsWrapper.getSessions());
                    RxBus.post(new ChatCounterBus(UserChatPresenter.this.userChatCounter.getCounter(UserChatPresenter.this.runningChatId)));
                    UserChatPresenter.this.view.userChatsFetched(userChatsWrapper);
                }
            }
        }, states);
    }

    public void handleError() {
        if (UserChatListState.USER_CHAT_LIST_LOADING.equals((Object)this.state)) {
            this.setState(UserChatListState.USER_CHAT_LIST_NOT_LOADED);
            this.view.setRefreshVisibility(true);
        }
    }

    @Override
    public void requestRemoveChat(final String chatId) {
        this.view.showProgress(ResUtils.getString(this.context, "ch.chat.delete_progress"));
        ChannelPlugin.getApi().removeUserChat(chatId).subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new RestSubscriber<Void>(){

            @Override
            public void onError(RetrofitException error) {
            }

            @Override
            public void onNext(Void aVoid) {
                UserChatPresenter.this.userChatCounter.delete(chatId);
                UserChatPresenter.this.adapterView.removeUserChat(chatId);
                UserChatPresenter.this.view.completeRemoveChat();
            }
        });
    }

    @Override
    public void onUserChatClick(String chatId) {
        if (!TextUtils.isEmpty((CharSequence)chatId)) {
            this.runningChatId = chatId;
            this.view.startChat(chatId, this.userChatCounter.getCounter(chatId), false);
        }
    }

    @Override
    public void onUserChatLongClick(String chatId) {
        if (!TextUtils.isEmpty((CharSequence)chatId)) {
            this.view.deleteChat(chatId);
        }
    }
}

