/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat;

import android.content.Context;
import android.text.TextUtils;
import com.zoyi.channel.plugin.android.activity.base.BaseDictionary;
import com.zoyi.channel.plugin.android.activity.chat.model.MobileNumberItem;
import com.zoyi.channel.plugin.android.model.interfaces.ChannelModel;
import com.zoyi.channel.plugin.android.model.rest.Bot;
import com.zoyi.channel.plugin.android.model.rest.Manager;
import com.zoyi.channel.plugin.android.model.rest.Script;
import com.zoyi.channel.plugin.android.util.CountryUtils;
import com.zoyi.channel.plugin.android.util.ResUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ChatDataDictionary
extends BaseDictionary {
    private static ChatDataDictionary instance;
    private List<Manager> follingManagers = new ArrayList<Manager>();
    private Map<String, Script> scriptMap = new HashMap<String, Script>();
    private String userName;
    private MobileNumberItem userMobilNumber = new MobileNumberItem(CountryUtils.getDefaultCountryCode(), "", -1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ChatDataDictionary getInstance() {
        if (instance != null) return instance;
        Class<ChatDataDictionary> clazz = ChatDataDictionary.class;
        synchronized (ChatDataDictionary.class) {
            if (instance != null) return instance;
            instance = new ChatDataDictionary();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private ChatDataDictionary() {
    }

    @Override
    public void release() {
        super.release();
        if (this.follingManagers != null) {
            this.follingManagers.clear();
        }
        if (this.scriptMap != null) {
            this.scriptMap.clear();
        }
        this.userName = null;
        this.userMobilNumber = new MobileNumberItem(CountryUtils.getDefaultCountryCode(), "", -1);
    }

    @Override
    public <E extends ChannelModel> E get(Class<E> clazz, String id2) {
        if (id2 != null) {
            String className;
            switch (className = clazz.getSimpleName()) {
                case "Manager": {
                    return (E)((ChannelModel)this.managerMap.get(id2));
                }
                case "Bot": {
                    return (E)((ChannelModel)this.botMap.get(id2));
                }
            }
        }
        return null;
    }

    @Override
    public void add(List<? extends ChannelModel> channelModels) {
        if (channelModels != null) {
            for (ChannelModel channelModel : channelModels) {
                String className;
                if (!this.checkCanUpdate(channelModel)) continue;
                switch (className = channelModel.getClass().getSimpleName()) {
                    case "Manager": {
                        this.managerMap.put(channelModel.getId(), (Manager)channelModel);
                        break;
                    }
                    case "Bot": {
                        this.botMap.put(channelModel.getId(), (Bot)channelModel);
                    }
                }
            }
        }
    }

    @Override
    protected void remove(ChannelModel channelModel) {
    }

    public void setFollowingManagers(List<Manager> managers) {
        this.follingManagers = managers;
    }

    public List<Manager> getFollingManagers() {
        return this.follingManagers;
    }

    public void setScripts(List<Script> scripts) {
        if (scripts != null) {
            for (Script script : scripts) {
                if (script.getKey() == null || script.getMessage() == null) continue;
                this.scriptMap.put(script.getKey(), script);
            }
        }
    }

    public String getScript(Context context, String key, String defaultResourceKey) {
        String message;
        if (this.scriptMap != null && this.scriptMap.containsKey(key) && !TextUtils.isEmpty((CharSequence)(message = this.scriptMap.get(key).getMessage(Locale.getDefault().getLanguage())))) {
            return message;
        }
        return ResUtils.getString(context, defaultResourceKey);
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setUserMobilNumber(MobileNumberItem userMobilNumber) {
        this.userMobilNumber = userMobilNumber;
    }

    public String getUserName() {
        return this.userName;
    }

    public MobileNumberItem getUserMobilNumber() {
        return this.userMobilNumber;
    }
}

