package com.zoyi.channel.plugin.android.model.rest;

import android.text.TextUtils;

/**
 * Created by mika on 2017. 1. 26..
 */
public class Script {
  private String id;
  private String channelId;
  private String pluginId;
  private String key;
  private String message;
  private I18n i18n;

  public String getKey() {
    return key;
  }

  public String getMessage() {
    return message;
  }

  public I18n getI18n() {
    return i18n;
  }

  public String getMessage(String locale) {
    String m = null;
    if (i18n != null && locale != null) {
      switch (locale) {
        case "ko":
          m = i18n.getKo();
          break;

        case "en":
          m = i18n.getEn();
          break;

        case "ja":
          m = i18n.getJa();
          break;
      }
    }
    if (TextUtils.isEmpty(m)) {
      return message;
    }
    return m;
  }
}
