package com.zoyi.channel.plugin.android.activity.settings;

import android.os.Bundle;
import android.support.annotation.AnimRes;
import android.support.annotation.Nullable;
import android.view.View;
import android.widget.TextView;

import com.zoyi.channel.plugin.android.BuildConfig;
import com.zoyi.channel.plugin.android.ChannelStore;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.util.Executor;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.view.layout.BigBar;
import com.zoyi.channel.plugin.android.view.layout.MenuButton;

public class SettingsActivity extends BaseActivity implements View.OnClickListener {

  private Channel channel;

  @Override
  protected void onCreate(@Nullable Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);
    init(R.layout.ch_plugin_activity_setting);

    channel = ChannelStore.getChannel();
    Plugin plugin = ChannelStore.getPlugin();

    if (channel == null || plugin == null) {
      finish();
      return;
    }
    setBigBar(plugin);

    findViewById(R.id.iv_channel_symbol).setOnClickListener(this);
    TextView textVersion = (TextView) findViewById(R.id.tv_plugin_version);
    textVersion.setText(BuildConfig.VERSION_NAME);
  }

  @Override
  @AnimRes
  protected int getEnterAnimOfCreate() {
    return R.anim.ch_plugin_slide_in_bottom;
  }

  @Override
  @AnimRes
  protected int getExistAnimOfFinish() {
    return R.anim.ch_plugin_slide_out_bottom;
  }

  private void setBigBar(Plugin plugin) {
    getBigBar().withActivity(this)
        .addMenu(MenuButton.ActionType.EXIT, BigBar.MenuPosition.LEFT)
        .build();
    getBigBar().setTheme(plugin.getBackgroundColor(), plugin.getTextColor());
    getBigBar().setTitle(ResUtils.getString(this, "ch.settings.title"));

    setStatusBarColor(plugin.getBackgroundColor());
  }

  @Override
  public void onClick(View v) {
    int id = v.getId();
    if (id == R.id.iv_channel_symbol) {
      Executor.goWeb(this, getUrl());
    }
  }

  private String getUrl() {
    return String.format(Const.UTM_URL, "plugin_exposure", channel.getName(), channel.getId());
  }
}
