package com.zoyi.channel.plugin.android.activity.userchat_list;

import android.support.v7.util.SortedList;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.ViewGroup;

import com.zoyi.channel.plugin.android.activity.base.SortedListCallback;
import com.zoyi.channel.plugin.android.model.rest.Session;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.model.source.userchat.UserChatItem;
import com.zoyi.channel.plugin.android.model.wrapper.UserChatsWrapper;
import com.zoyi.channel.plugin.android.presenter.userchat.UserChatAdapterContract;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by mika on 2016. 12. 6..
 */
class UserChatListAdapter extends RecyclerView.Adapter<UserChatHolder>
    implements UserChatAdapterContract.View, UserChatAdapterContract.Model {

  private OnUserChatClickListener clickListener;

  private Map<String, UserChatItem> map;
  private SortedList<UserChatItem> items;
  private boolean refreshBySocket = false;

  UserChatListAdapter() {
    map = new HashMap<>();
    items = new SortedList<>(UserChatItem.class, new SortedListCallback<UserChatItem>(this, true));
  }

  @Override
  public void setOnUserChatClickListener(OnUserChatClickListener clickListener) {
    this.clickListener = clickListener;
  }

  @Override
  public void removeUserChat(String chatId) {
    if (map.containsKey(chatId)) {
      items.remove(map.get(chatId));
    }
  }

  @Override
  public void clear() {
    if (map != null) {
      map.clear();
    }
    if (items != null) {
      items.clear();
    }
  }

  @Override
  public void init(UserChatsWrapper wrapper) {
    UserChatListDataDictionary dictionary = UserChatListDataDictionary.getInstance();

    for (UserChat userChat : wrapper.getUserChats()) {
      if (!TextUtils.isEmpty(userChat.getLastMessageId())) {
        UserChatItem item = new UserChatItem(userChat, dictionary);

        map.put(item.getId(), item);
        items.add(item);
      }
    }

    refreshBySocket = true;
  }

  @Override
  public void stopRefreshBySocket() {
    this.refreshBySocket = false;
  }

  @Override
  public void removeItem(UserChat userChat) {
    if (refreshBySocket && userChat != null) {
      String chatId = userChat.getId();

      if (map.containsKey(chatId)) {
        int position = items.indexOf(map.get(chatId));

        if (position >= 0) {
          map.remove(chatId);
          items.removeItemAt(position);
        }
      }
    }
  }

  @Override
  public void updateItem(UserChatItem item) {
    if (refreshBySocket) {
      int position = items.indexOf(item);

      if (position >= 0) {
        items.updateItemAt(position, item);
      }
    }
  }

  @Override
  public void addOrUpdateItem(UserChat userChat) {
    if (refreshBySocket && userChat != null) {
      UserChatListDataDictionary dictionary = UserChatListDataDictionary.getInstance();
      String chatId = userChat.getId();
      UserChatItem item;

      if (map.containsKey(chatId)) {
        item = map.get(chatId);
        item.setUserChat(userChat);

        updateItem(item);
      } else {
        item = new UserChatItem(userChat, dictionary);

        map.put(item.getId(), item);
        items.add(item);
      }
    }
  }

  @Override
  public UserChatHolder onCreateViewHolder(ViewGroup parent, int viewType) {
    return UserChatHolder.newInstance(parent, clickListener);
  }

  @Override
  public void onBindViewHolder(UserChatHolder holder, int position) {
    holder.setUserChatItem(items.get(position));
  }

  @Override
  public int getItemCount() {
    return items.size();
  }

  @Override
  public void updateManager(String managerId) {
    if (refreshBySocket) {
      for (int i = 0; i < items.size(); i++) {
        UserChatItem item = items.get(i);

        if (managerId.equals(item.getUserChat().getHostId())) {
          items.updateItemAt(i, item);
        }
      }
    }
  }

  @Override
  public void updateSession(Session session) {
    if (refreshBySocket && session != null) {
      for (int i = 0; i < items.size(); i++) {
        UserChatItem item = items.get(i);

        if (item.getSessionId().equals(session.getId())) {
          item.setSession(session);
          items.updateItemAt(i, item);
          break;
        }
      }
    }
  }
}
