/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Observable;
import com.zoyi.rx.Scheduler;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.exceptions.Exceptions;
import com.zoyi.rx.functions.Func0;
import com.zoyi.rx.functions.Func1;
import com.zoyi.rx.internal.operators.OperatorTimeoutBase;
import com.zoyi.rx.schedulers.Schedulers;
import com.zoyi.rx.subscriptions.Subscriptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperatorTimeoutWithSelector<T, U, V>
extends OperatorTimeoutBase<T> {
    public OperatorTimeoutWithSelector(final Func0<? extends Observable<U>> firstTimeoutSelector, final Func1<? super T, ? extends Observable<V>> timeoutSelector, Observable<? extends T> other) {
        super(new OperatorTimeoutBase.FirstTimeoutStub<T>(){

            @Override
            public Subscription call(final OperatorTimeoutBase.TimeoutSubscriber<T> timeoutSubscriber, final Long seqId, Scheduler.Worker inner) {
                if (firstTimeoutSelector != null) {
                    Observable o;
                    try {
                        o = (Observable)firstTimeoutSelector.call();
                    }
                    catch (Throwable t) {
                        Exceptions.throwOrReport(t, timeoutSubscriber);
                        return Subscriptions.unsubscribed();
                    }
                    return o.unsafeSubscribe(new Subscriber<U>(){

                        @Override
                        public void onCompleted() {
                            timeoutSubscriber.onTimeout(seqId);
                        }

                        @Override
                        public void onError(Throwable e) {
                            timeoutSubscriber.onError(e);
                        }

                        @Override
                        public void onNext(U t) {
                            timeoutSubscriber.onTimeout(seqId);
                        }
                    });
                }
                return Subscriptions.unsubscribed();
            }
        }, new OperatorTimeoutBase.TimeoutStub<T>(){

            @Override
            public Subscription call(final OperatorTimeoutBase.TimeoutSubscriber<T> timeoutSubscriber, final Long seqId, T value, Scheduler.Worker inner) {
                Observable o;
                try {
                    o = (Observable)timeoutSelector.call(value);
                }
                catch (Throwable t) {
                    Exceptions.throwOrReport(t, timeoutSubscriber);
                    return Subscriptions.unsubscribed();
                }
                return o.unsafeSubscribe(new Subscriber<V>(){

                    @Override
                    public void onCompleted() {
                        timeoutSubscriber.onTimeout(seqId);
                    }

                    @Override
                    public void onError(Throwable e) {
                        timeoutSubscriber.onError(e);
                    }

                    @Override
                    public void onNext(V t) {
                        timeoutSubscriber.onTimeout(seqId);
                    }
                });
            }
        }, other, Schedulers.immediate());
    }
}

