package com.zoyi.channel.plugin.android.view.layout;

import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.widget.Button;
import android.widget.EditText;
import com.zoyi.channel.plugin.android.util.lang.StringUtils;
import com.zoyi.channel.plugin.android.view.handler.EditTextChangedListener;

/**
 * Created by mika on 2016. 3. 9..
 */
public class WatchedEditText extends EditText {
  private EditTextChangedListener listener;
  private boolean block = false;
  private Button button;
  private int activeColor, deactiveColor;

  public WatchedEditText(Context context) {
    super(context);
  }

  public WatchedEditText(Context context, AttributeSet attrs) {
    super(context, attrs);
  }

  public WatchedEditText(Context context, AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
  }

  public void setWatchedTextChangedListener(EditTextChangedListener listener) {
    this.listener = listener;
    this.listener.onWatchedTextChanged(this.getText().toString());
  }

  public void setHandledButton(Button button, int activeColor, int deactiveColor) {
    this.button = button;
    this.activeColor = activeColor;
    this.deactiveColor = deactiveColor;

    setButtonStyle(getString());
  }

  @Override
  protected void onSelectionChanged(int start, int end) {
    super.onSelectionChanged(start, end);
  }

  @Override
  protected void onTextChanged(CharSequence text, int start, int lengthBefore, int lengthAfter) {
    super.onTextChanged(text, start, lengthBefore, lengthAfter);
    if (listener != null && !block) {
      listener.onWatchedTextChanged(text.toString());
    }
    setButtonStyle(text.toString());
  }

  private void setButtonStyle(String text) {
    if (button != null) {
      if ("".equals(StringUtils.stripEnd(text, null))) {
        button.setEnabled(false);
        button.setTextColor(deactiveColor);
      } else {
        button.setEnabled(true);
        button.setTextColor(activeColor);
      }
    }
  }

  public void setTextWithBlock(String text) {
    this.block = true;
    setText(text);
  }

  public void setBlock(boolean block) {
    this.block = block;
  }

  public String getString() {
    return getText().toString();
  }

  public boolean isEmpty() {
    return TextUtils.isEmpty(getString());
  }
}
