package com.zoyi.channel.plugin.android.activity.settings.edit;

import android.os.Bundle;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;

import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.view.layout.MenuButton;

public class EditNameActivity extends ProfileEditActivity {

  private String name;

  @Override
  protected void onCreate(@Nullable Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);

    textCountryCode.setVisibility(View.GONE);
    textDescription.setVisibility(View.GONE);

    setBigBarTitle(ResUtils.getString(this, "ch.settings.name_placeholder"));
    textLabel.setText(ResUtils.getString(this, "ch.settings.edit.name_label"));
    editText.setHint(ResUtils.getString(this, "ch.settings.edit.name_placeholder"));

    setEditTextPadding((int) Utils.dpToPx(this, 20));

    if (getIntent() != null) {
      name = getIntent().getStringExtra(Const.EXTRA_INPUT_VALUE);

      editText.setText(name);
      editText.setSelection(name.length());
    }
    onWatchedTextChanged(name);
  }

  @Override
  public void onWatchedTextChanged(String s) {
    s = s.trim();

    if (TextUtils.isEmpty(s)) {
      imageDelete.setVisibility(View.INVISIBLE);
      getBigBar().setMenuState(MenuButton.ActionType.DONE, MenuButton.MenuState.VISIBLE);
    } else {
      imageDelete.setVisibility(View.VISIBLE);
      getBigBar().setMenuState(
          MenuButton.ActionType.DONE,
          s.equals(name) ? MenuButton.MenuState.DISABLED : MenuButton.MenuState.VISIBLE);
    }
  }

  @Override
  public void optionClicked(MenuButton.ActionType actionType) {
    super.optionClicked(actionType);

    switch (actionType) {
      case DONE:
        presenter.updateUserName(editText.getString().trim());
        break;
    }
  }

  @Override
  protected void setEditTextPadding(int padding) {
    editText.setPadding(padding, 0, padding, 0);
  }
}
