package com.zoyi.channel.plugin.android.util;

import android.content.Context;
import android.content.DialogInterface;
import android.support.v7.app.AlertDialog;
import android.text.TextUtils;
import android.view.View;
import android.widget.Toast;

import com.zoyi.channel.plugin.android.model.rest.ProfileEntity;
import com.zoyi.channel.plugin.android.view.handler.AlertDialogListener;

import java.util.List;

/**
 * Created by mika on 2016. 12. 7..
 */
public class UIUtils {
  public static int getVisible(boolean visible, boolean goneWhenFalse) {
    return visible ? View.VISIBLE : (goneWhenFalse ? View.GONE : View.INVISIBLE);
  }

  public static String getNamesString(List<? extends ProfileEntity> profiles) {
    if (profiles == null || profiles.size() == 0) {
      return "Unknown";
    }
    String base = "";
    for (ProfileEntity profileEntity : profiles) {
      if (profileEntity != null && !TextUtils.isEmpty(profileEntity.getName())) {
        if (TextUtils.isEmpty(base)) {
          base = profileEntity.getName();
        } else {
          base = String.format("%s, %s", base, profileEntity.getName());
        }
      }
    }
    if (TextUtils.isEmpty(base)) {
      return "Unknown";
    }
    return base;
  }

  public static void showToast(Context context, String message) {
    Toast.makeText(context, message, Toast.LENGTH_SHORT).show();
  }

  public static void showAlertDialog(
      Context context,
      String message,
      boolean cancelable,
      AlertDialogListener listener) {
    showAlertDialog(
        context,
        message,
        context.getText(android.R.string.ok).toString(),
        context.getText(android.R.string.cancel).toString(),
        null,
        cancelable,
        listener);
  }

  public static void showAlertDialog(
      Context context,
      String message,
      String positive,
      String negative,
      String neutral,
      boolean cancelable,
      final AlertDialogListener listener) {
    AlertDialog.Builder builder = new AlertDialog.Builder(context);
    builder.setMessage(message);
    builder.setCancelable(cancelable);

    if (positive != null) {
      builder.setPositiveButton(positive, new DialogInterface.OnClickListener() {
        @Override
        public void onClick(DialogInterface dialog, int which) {
          if (listener != null) {
            listener.onPositive();
          }
        }
      });
    }

    if (negative != null) {
      builder.setNegativeButton(negative, new DialogInterface.OnClickListener() {
        @Override
        public void onClick(DialogInterface dialog, int which) {
          if (listener != null) {
            listener.onNegative();
          }
        }
      });
    }

    if (neutral != null) {
      builder.setNeutralButton(neutral, new DialogInterface.OnClickListener() {
        @Override
        public void onClick(DialogInterface dialog, int which) {
          if (listener != null) {
            listener.onNeutral();
          }
        }
      });
    }

    AlertDialog alertDialog = builder.create();
    try {
      alertDialog.setCanceledOnTouchOutside(false);
      alertDialog.show();
    } catch (Exception ignored) {
      if (listener != null) {
        listener.onError();
      }
    }
  }
}
