package com.zoyi.channel.plugin.android.activity.chat.type;

/**
 * Created by mika on 2016. 12. 8..
 */
public enum MessageType {
  ACTION_MESSAGE(0),
  QUESTION_MESSAGE(1),
  MANAGER_MESSAGE(2),
  USER_MESSAGE(3),
  DATE(4),
  NEW_MESSAGE_DIVIDER(5),
  SENDING(6),
  VERIFY(7),
  FETCH_FAILED(8),
  USER_INFO(9),
  UNKNOWN(100);

  private int value;
  MessageType(int value) {
    this.value = value;
  }

  public int toInt() {
    return value;
  }

  public static MessageType fromId(int id) {
    for (MessageType type : MessageType.values()) {
      if (type.toInt() == id) {
        return type;
      }
    }
    return UNKNOWN;
  }
}
