/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat;

import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AlertDialog;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.Button;
import android.widget.ImageButton;
import com.zoyi.channel.plugin.android.ChannelStore;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity;
import com.zoyi.channel.plugin.android.activity.chat.ChatAdapter;
import com.zoyi.channel.plugin.android.activity.chat.model.SendingMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.activity.download.DownloadActivity;
import com.zoyi.channel.plugin.android.activity.photo_album.PhotoAlbumActivity;
import com.zoyi.channel.plugin.android.activity.photo_picker.PhotoPickerActivity;
import com.zoyi.channel.plugin.android.enumerate.Command;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.ChannelModel;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.presenter.chat.ChatContract;
import com.zoyi.channel.plugin.android.presenter.chat.ChatPresenter;
import com.zoyi.channel.plugin.android.socket.SocketManager;
import com.zoyi.channel.plugin.android.util.Executor;
import com.zoyi.channel.plugin.android.util.IntentUtils;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.UIUtils;
import com.zoyi.channel.plugin.android.view.handler.BackgroundToucher;
import com.zoyi.channel.plugin.android.view.handler.InfiniteScrollListener;
import com.zoyi.channel.plugin.android.view.layout.BigBar;
import com.zoyi.channel.plugin.android.view.layout.MenuButton;
import com.zoyi.channel.plugin.android.view.layout.WatchedEditText;

public class ChatActivity
extends BaseActivity
implements ChatContract.View,
View.OnClickListener {
    private RecyclerView recyclerView;
    private WatchedEditText editChat;
    private Button buttonSend;
    private ImageButton buttonAttach;
    private View toast;
    private View reconnectLayout;
    private LinearLayoutManager layoutManager;
    private ChatContract.Presenter presenter;
    private ChatAdapter adapter;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.init(R.layout.ch_plugin_activity_chat);
        this.adapter = new ChatAdapter();
        this.presenter = new ChatPresenter((Context)this);
        this.adapter.setPresenter(this.presenter);
        this.presenter.setView(this);
        this.presenter.setAdapterModel(this.adapter);
        this.presenter.setAdapterView(this.adapter);
        this.buttonSend = (Button)this.findViewById(R.id.button_send);
        this.buttonSend.setOnClickListener((View.OnClickListener)this);
        this.buttonAttach = (ImageButton)this.findViewById(R.id.button_attach);
        this.buttonAttach.setOnClickListener((View.OnClickListener)this);
        this.toast = this.findViewById(R.id.layout_toast);
        this.toast.setOnClickListener((View.OnClickListener)this);
        this.findViewById(R.id.button_close_toast).setOnClickListener((View.OnClickListener)this);
        this.reconnectLayout = this.findViewById(R.id.layout_reconnect);
        this.layoutManager = new LinearLayoutManager((Context)this);
        this.layoutManager.setStackFromEnd(true);
        this.recyclerView = (RecyclerView)this.findViewById(R.id.recycler_chat);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.adapter);
        this.recyclerView.setItemAnimator(null);
        this.recyclerView.getRecycledViewPool().setMaxRecycledViews(MessageType.VERIFY.toInt(), 1);
        this.recyclerView.addOnScrollListener((RecyclerView.OnScrollListener)new InfiniteScrollListener(this.layoutManager, 1){

            @Override
            public void refresh() {
                ChatActivity.this.presenter.fetchBackwardMessages();
            }

            @Override
            public void firstItem(int index) {
                ChatActivity.this.presenter.calculateNewToast(index);
            }
        });
        this.editChat = (WatchedEditText)this.findViewById(R.id.edit_chat);
        this.editChat.setHandledButton(this.buttonSend, ContextCompat.getColor((Context)this, (int)R.color.ch_cobalt), ContextCompat.getColor((Context)this, (int)R.color.ch_gray));
        BackgroundToucher.makeKeyboardEvent(this, this.recyclerView, this.editChat);
        String chatId = null;
        int chatCount = 0;
        boolean chatEmpty = false;
        if (this.getIntent() != null) {
            chatId = this.getIntent().getStringExtra("chatId");
            chatCount = this.getIntent().getIntExtra("chatCount", 0);
            chatEmpty = this.getIntent().getBooleanExtra("chatEmpty", false);
        }
        this.getBigBar().withActivity(this).addMenu(MenuButton.ActionType.BACK, BigBar.MenuPosition.LEFT, chatEmpty ? MenuButton.MenuState.HIDDEN : MenuButton.MenuState.VISIBLE).addMenu(MenuButton.ActionType.EXIT, BigBar.MenuPosition.LEFT, chatEmpty ? MenuButton.MenuState.VISIBLE : MenuButton.MenuState.HIDDEN).addText(BigBar.MenuPosition.LEFT).addMenu(MenuButton.ActionType.REFRESH, BigBar.MenuPosition.RIGHT, MenuButton.MenuState.HIDDEN).build();
        this.getBigBar().setText(chatCount);
        if (SocketManager.isError()) {
            this.setReconnectVisibility(true);
        }
        this.setStyle();
        if (chatId != null) {
            this.presenter.setChatId(chatId);
        }
        this.presenter.init();
    }

    public void finish() {
        this.presenter.release();
        if (this.presenter.getChatId() == null) {
            this.setResult(22);
        } else {
            this.presenter.leaveChat();
        }
        super.finish();
    }

    private void setStyle() {
        Channel channel = ChannelStore.getChannel();
        Plugin plugin = ChannelStore.getPlugin();
        if (plugin != null) {
            this.presenter.setColor(plugin.getBackgroundColor(), plugin.getTextColor());
            this.setStatusBarColor(plugin.getBackgroundColor());
            this.getBigBar().setTheme(plugin.getBackgroundColor(), plugin.getTextColor());
        }
        if (channel != null) {
            this.getBigBar().setTitle(channel.getName());
        }
    }

    @Override
    public void onLoadUserChat() {
        this.getBigBar().setMenuState(MenuButton.ActionType.EXIT, MenuButton.MenuState.HIDDEN);
        this.getBigBar().setMenuState(MenuButton.ActionType.BACK, MenuButton.MenuState.VISIBLE);
    }

    @Override
    public void scrollToBottom(boolean force) {
        if (this.layoutManager.findLastCompletelyVisibleItemPosition() == this.adapter.getItemCount() - 2 || force) {
            this.layoutManager.scrollToPosition(this.adapter.getItemCount() - 1);
        }
    }

    @Override
    public void scrollTo(int index) {
        this.recyclerView.smoothScrollToPosition(index);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        switch (requestCode) {
            case 902: {
                if (resultCode != 12) break;
                this.presenter.sendImageFiles(data.getStringArrayListExtra("PHOTO_INTENT_KEY"));
            }
        }
    }

    @Override
    public void receiveCommand(Command command, Object object) {
        this.presenter.receiveCommand(command, object);
    }

    @Override
    public void receiveData(ChannelModel channelModel, boolean upsert) {
        this.presenter.receiveData(channelModel, upsert);
    }

    @Override
    public void receiveChatCounter(int count) {
        this.onLoadUserChat();
        this.getBigBar().setText(count);
    }

    @Override
    public void optionClicked(MenuButton.ActionType actionType) {
        super.optionClicked(actionType);
        switch (actionType) {
            case REFRESH: {
                this.presenter.refresh();
            }
        }
    }

    @Override
    public void setRefreshVisibility(boolean showRefresh) {
        this.getBigBar().setMenuState(MenuButton.ActionType.REFRESH, showRefresh ? MenuButton.MenuState.VISIBLE : MenuButton.MenuState.HIDDEN);
    }

    @Override
    public void setReconnectVisibility(boolean show) {
        this.reconnectLayout.setVisibility(UIUtils.getVisible(show, true));
    }

    @Override
    public void setToastVisibility(boolean showToast) {
        this.toast.setVisibility(UIUtils.getVisible(showToast, true));
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.layout_toast) {
            this.presenter.newToastClicked();
        }
        if (id2 == R.id.button_close_toast) {
            this.presenter.hideNewToast();
        }
        if (id2 == R.id.button_send) {
            this.presenter.sendTextMessage(this.editChat.getString());
            this.editChat.setText("");
        }
        if (id2 == R.id.button_attach) {
            this.hideKeyboard(this.editChat);
            IntentUtils.setNextActivity((Context)this, PhotoPickerActivity.class).startActivityForResult(902);
        }
    }

    @Override
    public void setPresenter(ChatContract.Presenter presenter) {
    }

    @Override
    public void onMessageClicked(Message message) {
        if (message.getFile() != null) {
            if (message.getFile().getPreviewThumb() == null || !message.getFile().isImage()) {
                IntentUtils.setNextActivity((Context)this, DownloadActivity.class).putExtra("url", message.getFile().getUrl()).putExtra("filename", message.getFile().getFilename()).putExtra("image", message.getFile().isImage()).startActivity();
            } else {
                IntentUtils.setNextActivity((Context)this, PhotoAlbumActivity.class).putExtra("url", message.getFile().getUrl()).putExtra("filename", message.getFile().getFilename()).putExtra("thumbnailUrl", message.getFile().getPreviewThumb().getUrl()).putExtra("size", message.getFile().getSize()).startActivity();
            }
        } else if (message.getWebPage() != null) {
            this.onUrlClicked(message.getWebPage().getUrl());
        }
    }

    @Override
    public void onUrlClicked(String url) {
        Executor.goWeb((Context)this, url);
    }

    @Override
    public void sendingMessageClicked(final SendingMessageItem item) {
        final AlertDialog dialog = new AlertDialog.Builder((Context)this).setMessage((CharSequence)ResUtils.getString((Context)this, "ch.chat.resend.description")).setPositiveButton((CharSequence)ResUtils.getString((Context)this, "ch.chat.resend"), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                ChatActivity.this.presenter.resend(item);
            }
        }).setNegativeButton((CharSequence)ResUtils.getString((Context)this, "ch.chat.resend.cancel"), null).setNeutralButton((CharSequence)ResUtils.getString((Context)this, "ch.chat.delete"), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                ChatActivity.this.presenter.removeFailedItem(item);
            }
        }).setCancelable(true).create();
        dialog.setOnShowListener(new DialogInterface.OnShowListener(){

            public void onShow(DialogInterface args) {
                int dark = ContextCompat.getColor((Context)ChatActivity.this, (int)R.color.ch_dark);
                int cobalt = ContextCompat.getColor((Context)ChatActivity.this, (int)R.color.ch_cobalt);
                dialog.getButton(-1).setTextColor(cobalt);
                dialog.getButton(-2).setTextColor(dark);
                dialog.getButton(-3).setTextColor(dark);
            }
        });
        dialog.show();
    }
}

