package com.zoyi.channel.plugin.android.util;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import com.zoyi.channel.plugin.android.global.Const;

/**
 * Created by mika on 2016. 4. 6..
 */
public class IntentUtils {
  private Context context;
  private Intent intent;

  public static IntentUtils setNextActivity(Context context, Class<?> clazz) {
    IntentUtils intentUtils = new IntentUtils();
    intentUtils.context = context;
    intentUtils.intent = new Intent(context, clazz);
    return intentUtils;
  }

  public IntentUtils() { }

  public IntentUtils putExtra(String key, Integer value) {
    if (value != null) {
      intent.putExtra(key, value);
    }
    return this;
  }

  public IntentUtils putExtra(String key, Long value) {
    if (value != null) {
      intent.putExtra(key, value);
    }
    return this;
  }

  public IntentUtils putExtra(String key, String value) {
    if (value != null) {
      intent.putExtra(key, value);
    }
    return this;
  }

  public IntentUtils putExtra(String key, Boolean value) {
    if (value != null) {
      intent.putExtra(key, value);
    }
    return this;
  }

  public void startActivity() {
    if (context != null && intent != null) {
      try {
        context.startActivity(intent);
      } catch (Exception ex) {
      }
    }
  }

  public void startActivityForResult(int requestCode) {
    if (context instanceof Activity) {
      intent.putExtra(Const.REQUEST_CODE_INTENT_KEY, requestCode);
      ((Activity) context).startActivityForResult(intent, requestCode);
    }
  }
}
