/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.userchat_list;

import com.zoyi.channel.plugin.android.ChannelStore;
import com.zoyi.channel.plugin.android.model.rest.Session;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UserChatCounter {
    private String personType;
    private String personId;
    private int total;
    private Map<String, Integer> counterMap = new HashMap<String, Integer>();

    public UserChatCounter() {
        this.personType = ChannelStore.getPersonType();
        this.personId = ChannelStore.getPersonId();
    }

    public void setList(List<Session> sessions) {
        this.counterMap.clear();
        this.total = 0;
        for (Session session : sessions) {
            if (session.getId() == null || !CompareUtils.isSame(session.getPersonType(), this.personType) || !CompareUtils.isSame(session.getPersonId(), this.personId)) continue;
            this.total += session.getAlert().intValue();
            this.counterMap.put(session.getChatId(), session.getAlert());
        }
    }

    public void upsert(Session session) {
        if (session != null && session.getId() != null) {
            if (this.counterMap.containsKey(session.getChatId())) {
                this.total -= this.counterMap.get(session.getChatId()).intValue();
            }
            this.counterMap.put(session.getChatId(), session.getAlert());
            this.total += session.getAlert().intValue();
        }
    }

    public void delete(Session session) {
        if (session != null && session.getChatId() != null && this.counterMap.containsKey(session.getChatId())) {
            this.total -= this.counterMap.get(session.getChatId()).intValue();
            this.counterMap.remove(session.getChatId());
        }
    }

    public int getCounter(String exceptionId) {
        if (exceptionId != null && this.counterMap.containsKey(exceptionId)) {
            return this.total - this.counterMap.get(exceptionId);
        }
        return this.total;
    }
}

