package com.zoyi.channel.plugin.android.activity.photo_album;

import android.animation.Animator;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.graphics.Color;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.view.View;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity;
import com.zoyi.channel.plugin.android.activity.download.DownloadActivity;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.util.IntentUtils;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.UIUtils;
import com.zoyi.channel.plugin.android.view.external.photoview.PhotoView;
import com.zoyi.channel.plugin.android.view.external.photoview.PhotoViewAttacher;
import com.zoyi.com.bumptech.glide.Glide;

/**
 * Created by mika on 2017. 1. 11..
 */
public class PhotoAlbumActivity extends BaseActivity
    implements View.OnClickListener, PhotoViewAttacher.OnPhotoTapListener {

  private static final int ANIMATION_DURATION = 200;

  private View layoutOverlay;

  private String url, thumbnailUrl, filename;
  private Long size;
  private boolean menuVisible = true;

  @Override
  protected void onCreate(@Nullable Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);
    init(R.layout.ch_plugin_activity_photo_album);
    setStatusBarColor(Color.BLACK);

    try {
      url = getIntent().getStringExtra(Const.EXTRA_URL);
      filename = getIntent().getStringExtra(Const.EXTRA_FILENAME);
      thumbnailUrl = getIntent().getStringExtra(Const.EXTRA_THUMBNAIL_URL);
      size = getIntent().getLongExtra(Const.EXTRA_SIZE, 0L);
    } finally {
      if (url == null || thumbnailUrl ==  null || filename == null || size == 0) {
        UIUtils.showToast(this, ResUtils.getString(this, "ch.photo.read_file_info_failed"));
        finish();
      }
    }

    PhotoView photoView = (PhotoView) findViewById(R.id.photo_view);
    layoutOverlay = findViewById(R.id.layout_image);

    photoView.setOnPhotoTapListener(this);
    findViewById(R.id.button_close_image).setOnClickListener(this);
    findViewById(R.id.button_link).setOnClickListener(this);
    findViewById(R.id.button_download).setOnClickListener(this);

    Glide.with(this)
        .load(url)
        .asBitmap()
        .dontAnimate()
        .fitCenter()
        .into(photoView);
  }

  @Override
  public void onClick(View view) {
    int id = view.getId();

    if (id == R.id.button_close_image) {
      finish();
    }
    if (id == R.id.button_link) {
      copyLink();
    }
    if (id == R.id.button_download) {
      download();
    }
  }

  private void copyLink() {
    try {
      ClipboardManager clipboard = (ClipboardManager) getSystemService(CLIPBOARD_SERVICE);
      ClipData clip = ClipData.newPlainText("text", url);
      clipboard.setPrimaryClip(clip);

      UIUtils.showToast(this, ResUtils.getString(this, "ch.photo.url_copied_to_clipboard"));
    } catch (Exception ex) {
      UIUtils.showToast(this, ResUtils.getString(this, "ch.photo.read_file_info_failed"));
    }
  }

  private void download() {
    IntentUtils.setNextActivity(this, DownloadActivity.class)
        .putExtra(Const.EXTRA_URL, url)
        .putExtra(Const.EXTRA_FILENAME, filename)
        .putExtra(Const.EXTRA_IMAGE, true)
        .startActivity();
  }

  @Override
  public void onPhotoTap(View view, float x, float y) {
    animateOverlay();
  }

  @Override
  public void onOutsidePhotoTap() {
    animateOverlay();
  }

  private void animateOverlay() {
    layoutOverlay.animate()
        .alpha(menuVisible ? 0f : 1f)
        .setDuration(ANIMATION_DURATION)
        .setListener(animatorListener).start();
  }

  private Animator.AnimatorListener animatorListener = new Animator.AnimatorListener() {
    @Override
    public void onAnimationStart(Animator animator) {
      menuVisible = !menuVisible;

      if (menuVisible) {
        layoutOverlay.setVisibility(View.VISIBLE);
      }
    }

    @Override
    public void onAnimationEnd(Animator animator) {
      layoutOverlay.setVisibility(menuVisible ? View.VISIBLE : View.GONE);
    }

    @Override
    public void onAnimationCancel(Animator animator) {}

    @Override
    public void onAnimationRepeat(Animator animator) {}
  };
}
