package com.zoyi.channel.plugin.android.view.handler;

import android.view.MotionEvent;
import android.view.View;

/**
 * Created by mika on 2016. 4. 14..
 */
public class ButtonTouchHandler implements View.OnTouchListener {
  private float normal = 1.0f;
  private float pressed = 0.3f;

  public ButtonTouchHandler(View view) {
    view.setAlpha(normal);
  }

  public ButtonTouchHandler(View view, float normal, float pressed) {
    this.normal = normal;
    this.pressed = pressed;
    view.setAlpha(normal);
  }

  @Override
  public boolean onTouch(View v, MotionEvent event) {
    if (v.isEnabled()) {
      switch (event.getAction()) {
        case MotionEvent.ACTION_DOWN:
          v.setAlpha(pressed);
          break;
        case MotionEvent.ACTION_UP:
        case MotionEvent.ACTION_CANCEL:
          v.setAlpha(normal);
          break;
      }
    }
    return false;
  }
}
