package com.zoyi.channel.plugin.android.activity.userchat_list;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.ProfileEntity;
import com.zoyi.channel.plugin.android.model.rest.Session;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.TimeUtils;
import com.zoyi.channel.plugin.android.util.UIUtils;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.view.layout.AvatarLayout;

import java.util.List;

/**
 * Created by mika on 2016. 12. 6..
 */
class UserChatHolder extends RecyclerView.ViewHolder {
  private Context context;

  private View singleAvatar, doubleAvatar, tripleAvatar;
  private AvatarLayout avatarSingle, avatarDouble1, avatarDouble2, avatarTriple1, avatarTriple2, avatarTriple3;
  private TextView textName, textTime, textMessage, textBadge;
  private UserChat userChat;

  UserChatHolder(View itemView) {
    super(itemView);

    this.context = itemView.getContext();

    singleAvatar = itemView.findViewById(R.id.layout_single);
    doubleAvatar = itemView.findViewById(R.id.layout_double);
    tripleAvatar = itemView.findViewById(R.id.layout_triple);

    avatarSingle = (AvatarLayout) itemView.findViewById(R.id.avatar_single);
    avatarDouble1 = (AvatarLayout) itemView.findViewById(R.id.avatar_double1);
    avatarDouble2 = (AvatarLayout) itemView.findViewById(R.id.avatar_double2);
    avatarTriple1 = (AvatarLayout) itemView.findViewById(R.id.avatar_triple1);
    avatarTriple2 = (AvatarLayout) itemView.findViewById(R.id.avatar_triple2);
    avatarTriple3 = (AvatarLayout) itemView.findViewById(R.id.avatar_triple3);

    avatarSingle.setTextSize(16);
    avatarDouble1.setTextSize(14);
    avatarDouble2.setTextSize(14);
    avatarTriple1.setTextSize(10);
    avatarTriple2.setTextSize(10);
    avatarTriple3.setTextSize(10);

    textName = (TextView) itemView.findViewById(R.id.text_name);
    textTime = (TextView) itemView.findViewById(R.id.text_time);
    textMessage = (TextView) itemView.findViewById(R.id.text_message);
    textBadge = (TextView) itemView.findViewById(R.id.text_badge);
  }

  void setUserChatItem(UserChatItem item) {
    this.userChat = item.getUserChat();
    Message message = item.getMessage();
    Session session = item.getSession();
    List<? extends ProfileEntity> profiles = item.getProfiles();

    textName.setText(UIUtils.getNamesString(profiles));

    if (message != null) {
      if (message.getFile() == null && message.getMessage() != null) {
        textMessage.setText(message.getMessage());
      } else {
        textMessage.setText(ResUtils.getString(context, "ch.notification.upload_file.description"));
      }
    } else {
      textMessage.setText("");
    }

    if (userChat != null && userChat.getUpdatedAt() != null) {
      textTime.setText(TimeUtils.get(userChat.getUpdatedAt()));
    } else {
      textTime.setText("");
    }

    if (session != null && session.getAlert() != null && session.getAlert() > 0) {
      textBadge.setVisibility(View.VISIBLE);
      textBadge.setText(Utils.getCount(session.getAlert(), true));
    } else {
      textBadge.setVisibility(View.GONE);
    }

    singleAvatar.setVisibility(View.GONE);
    doubleAvatar.setVisibility(View.GONE);
    tripleAvatar.setVisibility(View.GONE);

    if (profiles.size() == 1) {
      singleAvatar.setVisibility(View.VISIBLE);
      avatarSingle.set(profiles.get(0));
    } else if (profiles.size() == 2) {
      doubleAvatar.setVisibility(View.VISIBLE);
      avatarDouble1.set(profiles.get(0));
      avatarDouble2.set(profiles.get(1));
    } else if (profiles.size() > 2) {
      tripleAvatar.setVisibility(View.VISIBLE);
      avatarTriple1.set(profiles.get(0));
      avatarTriple2.set(profiles.get(1));
      avatarTriple3.set(profiles.get(2));
    }
  }

  public String getChatId() {
    if (userChat != null) {
      return userChat.getId();
    }
    return null;
  }
}
