/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.camera;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.os.Parcelable;
import android.provider.MediaStore;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity;
import com.zoyi.channel.plugin.android.activity.camera.RxImagePicker;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class HiddenActivity
extends BaseActivity {
    private static final String KEY_CAMERA_PICTURE_URL = "cameraPictureUrl";
    private Uri cameraPictureUrl;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState == null) {
            this.handleIntent(this.getIntent());
        }
    }

    protected void onSaveInstanceState(Bundle outState) {
        outState.putParcelable(KEY_CAMERA_PICTURE_URL, (Parcelable)this.cameraPictureUrl);
        super.onSaveInstanceState(outState);
    }

    protected void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        this.cameraPictureUrl = (Uri)savedInstanceState.getParcelable(KEY_CAMERA_PICTURE_URL);
    }

    protected void onNewIntent(Intent intent) {
        this.handleIntent(intent);
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        if (grantResults.length > 0 && grantResults[0] == 0) {
            this.handleIntent(this.getIntent());
        } else {
            this.finish();
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (resultCode == -1) {
            switch (requestCode) {
                case 903: {
                    if (this.cameraPictureUrl == null) break;
                    RxImagePicker.with((Context)this).onImagePicked(this.getRealPathFromURI((Context)this, this.cameraPictureUrl));
                }
            }
        }
        this.finish();
    }

    private void handleIntent(Intent intent) {
        if (!this.checkPermission()) {
            return;
        }
        this.cameraPictureUrl = this.createImageUri();
        Intent pictureChooseIntent = new Intent("android.media.action.IMAGE_CAPTURE");
        pictureChooseIntent.putExtra("output", (Parcelable)this.cameraPictureUrl);
        this.startActivityForResult(pictureChooseIntent, 903);
    }

    private String getRealPathFromURI(Context context, Uri contentUri) {
        Cursor cursor = null;
        try {
            String[] proj = new String[]{"_data"};
            cursor = context.getContentResolver().query(contentUri, proj, null, null, null);
            if (cursor != null) {
                int column_index = cursor.getColumnIndexOrThrow("_data");
                cursor.moveToFirst();
                return cursor.getString(column_index);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (cursor != null) {
            cursor.close();
        }
        return null;
    }

    private boolean checkPermission() {
        if (ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.WRITE_EXTERNAL_STORAGE") != 0) {
            ActivityCompat.requestPermissions((Activity)this, (String[])new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"}, (int)0);
            return false;
        }
        return true;
    }

    private Uri createImageUri() {
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss", Locale.getDefault()).format(new Date());
        String filePath = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DCIM) + "/Camera/" + timeStamp + ".jpg";
        ContentResolver contentResolver = this.getContentResolver();
        ContentValues values = new ContentValues();
        values.put("title", timeStamp);
        values.put("_display_name", timeStamp + ".jpg");
        values.put("mime_type", "image/jpeg");
        values.put("_data", filePath);
        values.put("datetaken", Long.valueOf(System.currentTimeMillis()));
        return contentResolver.insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, values);
    }
}

