/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android;

import android.app.Application;
import android.content.Context;
import android.os.Looper;
import com.splunk.mint.Mint;
import com.zoyi.channel.plugin.android.ActivityLifecycleManager;
import com.zoyi.channel.plugin.android.ChannelException;
import com.zoyi.channel.plugin.android.ChannelStore;
import com.zoyi.channel.plugin.android.CheckIn;
import com.zoyi.channel.plugin.android.OnCheckInListener;
import com.zoyi.channel.plugin.android.activity.userchat_list.UserChatListActivity;
import com.zoyi.channel.plugin.android.enumerate.Command;
import com.zoyi.channel.plugin.android.event.CommandBus;
import com.zoyi.channel.plugin.android.event.RxBus;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.model.wrapper.PackageWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.PluginWrapper;
import com.zoyi.channel.plugin.android.network.ChannelApi;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.channel.plugin.android.network.ServiceFactory;
import com.zoyi.channel.plugin.android.socket.SocketManager;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import com.zoyi.channel.plugin.android.util.IntentUtils;
import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.channel.plugin.android.util.RequestUtils;
import com.zoyi.retrofit2.okhttp3.RequestBody;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.android.schedulers.AndroidSchedulers;
import com.zoyi.rx.schedulers.Schedulers;
import java.util.HashMap;
import java.util.concurrent.RejectedExecutionException;

public class ChannelPlugin {
    private static boolean isDebugMode = false;
    private static ChannelPlugin channelPlugin;
    private static ChannelApi channelApi;
    private Application application;
    private String pluginId;
    private Thread.UncaughtExceptionHandler mUncaughtExceptionHandler;
    private boolean doCheckIn = false;

    public static void initialize(Application application, String pluginId) {
        ChannelPlugin.initialize(application, pluginId, false);
    }

    public static void initialize(Application application, String pluginId, boolean debugMode) {
        if (channelPlugin != null) {
            L.i("Channel plugin already initialized");
            return;
        }
        if (application == null) {
            L.e("Application cannot be null");
            return;
        }
        if (pluginId == null) {
            L.e("Plugin key cannot be null");
            return;
        }
        isDebugMode = debugMode;
        channelPlugin = new ChannelPlugin(application, pluginId);
    }

    private ChannelPlugin(Application application, String pluginId) {
        this.application = application;
        this.pluginId = pluginId;
        ChannelStore.create(application, pluginId);
        SocketManager.create(application);
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new ActivityLifecycleManager());
        this.mUncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable ex) {
                if (Looper.getMainLooper().getThread() == thread) {
                    ChannelPlugin.this.mUncaughtExceptionHandler.uncaughtException(thread, ex);
                } else if (ex instanceof RejectedExecutionException) {
                    SocketManager.reconnect();
                }
            }
        });
    }

    private void checkVersion(final CheckIn checkIn, final OnCheckInListener listener) {
        if (!this.doCheckIn) {
            this.doCheckIn = true;
            ChannelPlugin.checkOut();
            ChannelPlugin.getApi().getLastestPackage("com.zoyi.channel.plugin.android", "0.0.6").subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new RestSubscriber<PackageWrapper>(){

                @Override
                public void onError(Throwable error) {
                    ChannelPlugin.this.doCheckIn = false;
                    if (listener != null) {
                        listener.onFailed(new ChannelException(ChannelException.StatusCode.NETWORK_TIMEOUT, error.getMessage()));
                    }
                }

                @Override
                public void onNext(PackageWrapper wrapper) {
                    if (!wrapper.isNeedToUpgrade()) {
                        L.i(wrapper.getVersionString() + " " + "0.0.6");
                        if (!CompareUtils.isSame(wrapper.getVersionString(), "0.0.6")) {
                            L.i("Newest version is: " + wrapper.getVersionString());
                        }
                        ChannelPlugin.this.checkInProcess(checkIn, listener);
                    } else {
                        ChannelPlugin.this.doCheckIn = false;
                        if (listener != null) {
                            listener.onFailed(new ChannelException(ChannelException.StatusCode.NOT_AVAILABLE_VERSION, "Need to upgrade, Minimum version is: " + wrapper.getMinCompatibleVersion()));
                        }
                    }
                }
            });
        }
    }

    private void checkInProcess(CheckIn checkIn, final OnCheckInListener listener) {
        HashMap<String, Object> form = new HashMap<String, Object>();
        if (checkIn != null) {
            form.put("name", checkIn.getName());
            form.put("mobileNumber", checkIn.getMobileNumber());
            form.put("avatarUrl", checkIn.getAvatarUrl());
            form.put("meta", checkIn.getMeta());
        }
        RequestBody body = RequestUtils.form(form).create();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (checkIn != null && checkIn.getUserId() != null) {
            headers.put("X-User-Id", checkIn.getUserId());
        }
        if (PrefSupervisor.getVeilId((Context)this.application) != null) {
            headers.put("X-Veil-Id", PrefSupervisor.getVeilId((Context)this.application));
        }
        ChannelPlugin.getApi().checkIn(headers, this.pluginId, "channel.io", body).subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new RestSubscriber<PluginWrapper>(){

            @Override
            public void onError(Throwable e) {
                L.e(e.getMessage());
                ChannelPlugin.this.doCheckIn = false;
                if (listener != null) {
                    listener.onFailed(new ChannelException(ChannelException.StatusCode.NETWORK_TIMEOUT, e.getMessage()));
                }
            }

            @Override
            public void onNext(PluginWrapper pluginWrapper) {
                ChannelPlugin.this.initBugTracking();
                ChannelStore.checkIn(pluginWrapper);
                SocketManager.setChannelId(pluginWrapper.getChannel().getId());
                SocketManager.connect();
                RxBus.post(new CommandBus(Command.CHECKED_IN, pluginWrapper.getPlugin()));
                ChannelPlugin.this.doCheckIn = false;
                if (listener != null) {
                    listener.onSuccessed();
                }
            }
        });
    }

    private void checkOutProcess() {
        ChannelStore.clear();
        RxBus.post(new CommandBus(Command.CHECKED_OUT));
        SocketManager.setChannelId(null);
        SocketManager.disconnect();
        this.releaseBugTracking();
    }

    private static boolean isInitialized() {
        if (channelPlugin == null) {
            L.e("Please initialize first");
            return false;
        }
        return true;
    }

    public static void checkIn() {
        ChannelPlugin.checkIn(null, null);
    }

    public static void checkIn(OnCheckInListener listener) {
        ChannelPlugin.checkIn(null, listener);
    }

    public static void checkIn(CheckIn checkIn) {
        ChannelPlugin.checkIn(checkIn, null);
    }

    public static void checkIn(CheckIn checkIn, OnCheckInListener listener) {
        if (ChannelPlugin.isInitialized()) {
            channelPlugin.checkVersion(checkIn, listener);
        } else if (listener != null) {
            listener.onFailed(new ChannelException(ChannelException.StatusCode.NOT_INITIALIZED, "Please initialize first"));
        }
    }

    public static void checkOut() {
        if (ChannelPlugin.isInitialized()) {
            channelPlugin.checkOutProcess();
        }
    }

    public static boolean launch(Context context) {
        if (!ChannelPlugin.isInitialized() || !ChannelStore.isCheckedIn() || context == null) {
            L.e("Please check in first");
            return false;
        }
        IntentUtils.setNextActivity(context, UserChatListActivity.class).startActivity();
        return true;
    }

    public static ChannelApi getApi() {
        if (channelApi == null) {
            channelApi = ServiceFactory.create();
        }
        return channelApi;
    }

    public static boolean isDebugMode() {
        return isDebugMode;
    }

    private void initBugTracking() {
        if (this.application != null) {
            Mint.disableNetworkMonitoring();
            Mint.initAndStartSession((Application)this.application, (String)"22464da6");
            Mint.addExtraData((String)"plugin_version", (String)"0.0.6");
        }
    }

    private void releaseBugTracking() {
        if (this.application != null) {
            Mint.clearExtraData();
            Mint.closeSession((Application)this.application);
            Mint.flush();
        }
    }

    public static boolean isCheckedIn() {
        return ChannelStore.isCheckedIn();
    }
}

