package com.zoyi.channel.plugin.android.activity.userchat_list;

import com.zoyi.channel.plugin.android.ChannelPlugin;
import com.zoyi.channel.plugin.android.ChannelStore;
import com.zoyi.channel.plugin.android.model.rest.Session;
import com.zoyi.channel.plugin.android.util.CompareUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by mika on 2017. 2. 6..
 */
class UserChatCounter {
  private String personType, personId;
  private int total;
  private Map<String, Integer> counterMap;

  UserChatCounter() {
    counterMap = new HashMap<>();
    personType = ChannelStore.getPersonType();
    personId = ChannelStore.getPersonId();
  }

  void setList(List<Session> sessions) {
    counterMap.clear();
    total = 0;
    for (Session session : sessions) {
      if (session.getId() != null
          && CompareUtils.isSame(session.getPersonType(), personType)
          && CompareUtils.isSame(session.getPersonId(), personId)) {
        total += session.getAlert();
        counterMap.put(session.getChatId(), session.getAlert());
      }
    }
  }

  void upsert(Session session) {
    if (session != null && session.getId() != null) {
      if (counterMap.containsKey(session.getChatId())) {
        total -= counterMap.get(session.getChatId());
      }
      counterMap.put(session.getChatId(), session.getAlert());
      total += session.getAlert();
    }
  }

  void delete(Session session) {
    if (session != null && session.getChatId() != null && counterMap.containsKey(session.getChatId())) {
      total -= counterMap.get(session.getChatId());
      counterMap.remove(session.getChatId());
    }
  }

  int getCounter(String exceptionId) {
    if (exceptionId != null && counterMap.containsKey(exceptionId)) {
      return total - counterMap.get(exceptionId);
    }
    return total;
  }
}
