package com.zoyi.channel.plugin.android.view.layout;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.os.Build;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.zoyi.com.bumptech.glide.Glide;
import com.zoyi.com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.model.rest.ProfileEntity;

/**
 * Created by mika on 2016. 2. 2..
 */
public class AvatarLayout extends FrameLayout {
  public AvatarLayout(Context context) {
    super(context);
    init(context, null);
  }

  public AvatarLayout(Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);
    init(context, attrs);
  }

  public AvatarLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
    init(context, attrs);
  }

  @TargetApi(Build.VERSION_CODES.LOLLIPOP)
  public AvatarLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
    super(context, attrs, defStyleAttr, defStyleRes);
    init(context, attrs);
  }

  Context context;
  ImageView back, image;
  TextView text;

  protected void init(Context context, AttributeSet attrs) {
    this.context = context;
    View view = LayoutInflater.from(context).inflate(R.layout.ch_plugin_layout_avatar, this);
    back = (ImageView) view.findViewById(R.id.back_profile);
    image = (ImageView) view.findViewById(R.id.image_profile);
    text = (TextView) view.findViewById(R.id.text_profile);

    int textSize = 16;

    if (attrs != null) {
      TypedArray typedArray = context.getTheme().obtainStyledAttributes(
          attrs,
          R.styleable.AvatarLayout,
          0,
          0);

      try {
        textSize = typedArray.getDimensionPixelSize(R.styleable.AvatarLayout_ch_initialSize, textSize);
      } finally {
        typedArray.recycle();
      }
    }

    text.setTextSize(TypedValue.COMPLEX_UNIT_PX, textSize);
  }

  private void reset(boolean isImage) {
    if (isImage) {
      back.setBackgroundColor(Color.WHITE);
      image.setVisibility(VISIBLE);
      text.setVisibility(GONE);
    } else {
      image.setVisibility(GONE);
      text.setVisibility(VISIBLE);
    }
  }

  public void set(ProfileEntity entity) {
    if (entity == null) {
      reset(false);
      back.setBackgroundColor(ContextCompat.getColor(context, R.color.ch_dark));
      text.setTextColor(Color.WHITE);
      text.setText("?");
    } else if (entity.getAvatarUrl() != null) {
      reset(true);
      Glide.with(getContext())
          .load(entity.getAvatarUrl())
          .centerCrop()
          .dontAnimate()
          .diskCacheStrategy(DiskCacheStrategy.RESULT)
          .into(image);
    } else {
      reset(false);
      back.setBackgroundColor(entity.getBackgroundColor());
      text.setTextColor(entity.getTextColor());
      text.setText(entity.getInitial());
    }
  }

  public void setTextSize(int size) {
    text.setTextSize(TypedValue.COMPLEX_UNIT_SP, size);
  }
}
