package com.zoyi.channel.plugin.android.activity.chat;

import android.webkit.MimeTypeMap;
import com.zoyi.channel.plugin.android.ChannelPlugin;
import com.zoyi.channel.plugin.android.ChannelStore;
import com.zoyi.channel.plugin.android.activity.chat.listener.ChatActionCallback;
import com.zoyi.channel.plugin.android.activity.chat.listener.MessageCallback;
import com.zoyi.channel.plugin.android.activity.chat.model.SendingMessageItem;
import com.zoyi.channel.plugin.android.model.wrapper.MessageWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.MessagesWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.UserChatWrapper;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.channel.plugin.android.network.RetrofitException;
import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.channel.plugin.android.util.RequestUtils;
import com.zoyi.channel.plugin.android.util.io.FilenameUtils;
import com.zoyi.retrofit2.okhttp3.MediaType;
import com.zoyi.retrofit2.okhttp3.MultipartBody;
import com.zoyi.retrofit2.okhttp3.RequestBody;
import com.zoyi.rx.android.schedulers.AndroidSchedulers;
import com.zoyi.rx.schedulers.Schedulers;

import java.io.File;

/**
 * Created by mika on 2016. 12. 7..
 */
public class ChatAction {
  private ChatActionCallback callback;

  public ChatAction(ChatActionCallback callback) {
    this.callback = callback;
  }

  public void fetchUserChat(String chatId) {
    ChannelPlugin.getApi().getUserChat(chatId)
        .subscribeOn(Schedulers.newThread())
        .observeOn(AndroidSchedulers.mainThread())
        .subscribe(new RestSubscriber<UserChatWrapper>() {
          @Override
          public void onError(RetrofitException error) {
            L.e(error.getMessage());
            if (callback != null) {
              callback.userChatFetched(null);
            }
          }

          @Override
          public void onNext(UserChatWrapper userChatWrapper) {
            if (callback != null) {
              callback.userChatFetched(userChatWrapper);
            }
          }
        });
  }

  public void fetchMessages(
      String chatId,
      String next,
      String order,
      final int counter,
      final MessageCallback callback) {
    ChannelPlugin.getApi()
        .getMessages(
            chatId,
            next,
            30,
            order)
        .subscribeOn(Schedulers.newThread())
        .observeOn(AndroidSchedulers.mainThread())
        .subscribe(new RestSubscriber<MessagesWrapper>() {
          @Override
          public void onError(RetrofitException error) {
            callback.messagesFetched(counter, null);
          }

          @Override
          public void onNext(MessagesWrapper wrapper) {
            callback.messagesFetched(counter, wrapper);
          }
        });
  }

  public void readAll(String chatId) {
    ChannelPlugin.getApi().readAll(chatId)
        .subscribeOn(Schedulers.newThread())
        .observeOn(AndroidSchedulers.mainThread())
        .subscribe(new RestSubscriber<Void>());
  }

  public void sendMessage(String userChatId, SendingMessageItem item) {
    RequestBody body = RequestUtils.form()
        .set("message", item.getMessage())
        .set("requestId", item.getRequestId())
        .create();

    ChannelPlugin.getApi().sendMessage(userChatId, body)
        .subscribeOn(Schedulers.newThread())
        .observeOn(AndroidSchedulers.mainThread())
        .subscribe(new RestSubscriber<MessageWrapper>() {
          @Override
          public void onError(RetrofitException error) {
            if (callback != null) {
              callback.receiveMessage(null);
            }
          }

          @Override
          public void onNext(MessageWrapper messageWrapper) {
            if (callback != null) {
              callback.receiveMessage(messageWrapper.getMessage());
            }
          }
        });
  }

  public void uploadFile(String userChatId, SendingMessageItem item) {
    String path = item.getString();

    MimeTypeMap mimeTypeMap = MimeTypeMap.getSingleton();
    String type = mimeTypeMap.getMimeTypeFromExtension(FilenameUtils.getExtension(path.toLowerCase()));

    if (type == null) {
      if (callback != null) {
        callback.receiveMessage(null);
      }
      return;
    }

    File file = new File(path);
    RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), file);
    RequestBody timestamp = RequestBody.create(MediaType.parse("text/plane"), item.getRequestId());
    MultipartBody.Part body = MultipartBody.Part.createFormData("file", file.getName(), requestFile);

    ChannelPlugin.getApi().uploadFile(userChatId, body, timestamp)
        .subscribeOn(Schedulers.newThread())
        .observeOn(AndroidSchedulers.mainThread())
        .subscribe(new RestSubscriber<MessageWrapper>() {
          @Override
          public void onError(RetrofitException error) {
            if (callback != null) {
              callback.receiveMessage(null);
            }
          }

          @Override
          public void onNext(MessageWrapper messageWrapper) {
            if (callback != null) {
              callback.receiveMessage(messageWrapper.getMessage());
            }
          }
        });
  }

  void createUserChat() {
    if (ChannelStore.getPluginId() != null) {
      ChannelPlugin.getApi().createUserChat(ChannelStore.getPluginId())
          .subscribeOn(Schedulers.newThread())
          .observeOn(AndroidSchedulers.mainThread())
          .subscribe(new RestSubscriber<UserChatWrapper>() {
            @Override
            public void onError(RetrofitException error) {
              if (callback != null) {
                callback.userChatFetched(null);
              }
            }

            @Override
            public void onNext(UserChatWrapper userChatWrapper) {
              if (callback != null) {
                callback.userChatFetched(userChatWrapper);
              }
            }
          });
    }
  }
}
