/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.util;

import com.zoyi.channel.plugin.android.util.lang.DateUtils;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class TimeUtils {
    public static final SimpleDateFormat FULL_YEAR = new SimpleDateFormat("yyyy", Locale.getDefault());
    public static final SimpleDateFormat FULL_DAY = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());
    public static final SimpleDateFormat FULL_MINUTE = new SimpleDateFormat("yyyy-MM-dd HH:mm", Locale.getDefault());
    public static final SimpleDateFormat SIMPLE_DAY = new SimpleDateFormat("yyyy-M-d", Locale.getDefault());
    public static final SimpleDateFormat SIMPLE_DATE = new SimpleDateFormat("M/d", Locale.getDefault());
    public static final SimpleDateFormat SIMPLE_YEAR = new SimpleDateFormat("yy/M/d", Locale.getDefault());
    public static final SimpleDateFormat SECOND = new SimpleDateFormat("HH:mm:ss", Locale.getDefault());
    public static final SimpleDateFormat MINUTE_24 = new SimpleDateFormat("H:mm", Locale.getDefault());
    public static final SimpleDateFormat MINUTE_12 = new SimpleDateFormat("h:mm", Locale.getDefault());
    public static final Long MAX_MICROSECONDS = 10000000000000000L;
    public static long OFFSET = 0L;

    public static String get(SimpleDateFormat format, Long ts) {
        return TimeUtils.get(format, new Date(ts));
    }

    public static String get(SimpleDateFormat format, Date date) {
        return format.format(date);
    }

    public static String get(Long ts) {
        if (ts == null) {
            return "";
        }
        Date date = new Date(ts);
        Date now = new Date(System.currentTimeMillis());
        if (DateUtils.isSameDay(now, date)) {
            return TimeUtils.getTime(date);
        }
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(now);
        int year1 = cal1.get(1) - 1900;
        int year2 = cal2.get(1) - 1900;
        if (year1 == year2) {
            return TimeUtils.get(SIMPLE_DATE, date);
        }
        return TimeUtils.get(FULL_DAY, date);
    }

    public static String getTime(Long ts) {
        return TimeUtils.getTime(new Date(ts));
    }

    public static String getTime(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        String time = TimeUtils.get(MINUTE_12, date);
        return String.format("%s%s", time, cal.get(9) == 1 ? "pm" : "am");
    }

    public static String getFullYear(Long ts) {
        String date = TimeUtils.get(SIMPLE_DAY, ts);
        String time = TimeUtils.getTime(ts);
        return String.format("%s %s", date, time);
    }
}

