/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat;

import android.content.Context;
import com.zoyi.channel.plugin.android.model.Pair;
import com.zoyi.channel.plugin.android.util.ResUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class CountryDictionary {
    private List<Pair> countries = new ArrayList<Pair>();
    private List<String> countryNames;

    public CountryDictionary(Context context) {
        this.countries.add(new Pair("us", "1"));
        this.countries.add(new Pair("ca", "1"));
        this.countries.add(new Pair("ru", "7"));
        this.countries.add(new Pair("za", "7"));
        this.countries.add(new Pair("fr", "33"));
        this.countries.add(new Pair("it", "39"));
        this.countries.add(new Pair("gb", "44"));
        this.countries.add(new Pair("de", "49"));
        this.countries.add(new Pair("mx", "52"));
        this.countries.add(new Pair("ar", "54"));
        this.countries.add(new Pair("br", "55"));
        this.countries.add(new Pair("my", "60"));
        this.countries.add(new Pair("au", "61"));
        this.countries.add(new Pair("id", "62"));
        this.countries.add(new Pair("ph", "63"));
        this.countries.add(new Pair("sg", "65"));
        this.countries.add(new Pair("th", "66"));
        this.countries.add(new Pair("jp", "81"));
        this.countries.add(new Pair("kr", "82"));
        this.countries.add(new Pair("vn", "84"));
        this.countries.add(new Pair("cn", "86"));
        this.countries.add(new Pair("tr", "90"));
        this.countries.add(new Pair("in", "91"));
        this.countries.add(new Pair("hk", "852"));
        this.countries.add(new Pair("mo", "853"));
        this.countries.add(new Pair("tw", "886"));
        this.countries.add(new Pair("sa", "966"));
        this.countryNames = new ArrayList<String>();
        for (Pair pair : this.countries) {
            this.countryNames.add(ResUtils.getString(context, String.format("ch.mobile_verification.country.%s", pair.getFirst())));
        }
    }

    public String getDefaultCountryCode() {
        String lang;
        switch (lang = Locale.getDefault().getLanguage().toUpperCase()) {
            case "KO": {
                return "82";
            }
            case "JA": {
                return "81";
            }
        }
        return "1";
    }

    public List<String> getCountryNames() {
        return this.countryNames;
    }

    public String getCode(int index) {
        if (index >= 0 && index < this.countries.size()) {
            return this.countries.get(index).getSecond();
        }
        return "0";
    }
}

