/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.subjects;

import com.zoyi.rx.Observable;
import com.zoyi.rx.Scheduler;
import com.zoyi.rx.functions.Action0;
import com.zoyi.rx.functions.Action1;
import com.zoyi.rx.internal.operators.NotificationLite;
import com.zoyi.rx.schedulers.TestScheduler;
import com.zoyi.rx.subjects.Subject;
import com.zoyi.rx.subjects.SubjectSubscriptionManager;
import java.util.concurrent.TimeUnit;

public final class TestSubject<T>
extends Subject<T, T> {
    private final SubjectSubscriptionManager<T> state;
    private final Scheduler.Worker innerScheduler;

    public static <T> TestSubject<T> create(TestScheduler scheduler) {
        final SubjectSubscriptionManager state = new SubjectSubscriptionManager();
        state.onAdded = new Action1<SubjectSubscriptionManager.SubjectObserver<T>>(){

            @Override
            public void call(SubjectSubscriptionManager.SubjectObserver<T> o) {
                o.emitFirst(state.getLatest(), state.nl);
            }
        };
        state.onTerminated = state.onAdded;
        return new TestSubject(state, state, scheduler);
    }

    protected TestSubject(Observable.OnSubscribe<T> onSubscribe, SubjectSubscriptionManager<T> state, TestScheduler scheduler) {
        super(onSubscribe);
        this.state = state;
        this.innerScheduler = scheduler.createWorker();
    }

    @Override
    public void onCompleted() {
        this.onCompleted(0L);
    }

    void internalOnCompleted() {
        if (this.state.active) {
            for (SubjectSubscriptionManager.SubjectObserver<T> bo : this.state.terminate(NotificationLite.instance().completed())) {
                bo.onCompleted();
            }
        }
    }

    public void onCompleted(long delayTime) {
        this.innerScheduler.schedule(new Action0(){

            @Override
            public void call() {
                TestSubject.this.internalOnCompleted();
            }
        }, delayTime, TimeUnit.MILLISECONDS);
    }

    @Override
    public void onError(Throwable e) {
        this.onError(e, 0L);
    }

    void internalOnError(Throwable e) {
        if (this.state.active) {
            for (SubjectSubscriptionManager.SubjectObserver<T> bo : this.state.terminate(NotificationLite.instance().error(e))) {
                bo.onError(e);
            }
        }
    }

    public void onError(final Throwable e, long delayTime) {
        this.innerScheduler.schedule(new Action0(){

            @Override
            public void call() {
                TestSubject.this.internalOnError(e);
            }
        }, delayTime, TimeUnit.MILLISECONDS);
    }

    @Override
    public void onNext(T v) {
        this.onNext(v, 0L);
    }

    void internalOnNext(T v) {
        for (SubjectSubscriptionManager.SubjectObserver<T> o : this.state.observers()) {
            o.onNext(v);
        }
    }

    public void onNext(final T v, long delayTime) {
        this.innerScheduler.schedule(new Action0(){

            @Override
            public void call() {
                TestSubject.this.internalOnNext(v);
            }
        }, delayTime, TimeUnit.MILLISECONDS);
    }

    @Override
    public boolean hasObservers() {
        return this.state.observers().length > 0;
    }
}

