package com.zoyi.channel.plugin.android.activity.photo_album;

import android.content.ClipData;
import android.content.ClipboardManager;
import android.graphics.Color;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.animation.AlphaAnimation;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.UIUtils;
import com.zoyi.com.bumptech.glide.Glide;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity;
import com.zoyi.channel.plugin.android.activity.download.DownloadActivity;
import com.zoyi.channel.plugin.android.util.IntentUtils;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.view.external.photoview.PhotoView;
import com.zoyi.channel.plugin.android.view.external.photoview.PhotoViewAttacher;

/**
 * Created by mika on 2017. 1. 11..
 */
public class PhotoAlbumActivity extends BaseActivity implements PhotoViewAttacher.OnPhotoTapListener {
  PhotoView photoView;
  View layoutOverlay, buttonClose, buttonCopyLink, buttonDownload;

  private String url, thumbnailUrl, filename;
  private Long size;
  private boolean menuVisible = true;

  @Override
  protected void onCreate(@Nullable Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);
    init(R.layout.ch_plugin_activity_photo_album);
    setStatusBarColor(Color.BLACK);

    photoView = (PhotoView) findViewById(R.id.photo_view);
    layoutOverlay = findViewById(R.id.layout_image);
    buttonClose = findViewById(R.id.button_close_image);
    buttonCopyLink = findViewById(R.id.button_link);
    buttonDownload = findViewById(R.id.button_download);

    try {
      url = getIntent().getStringExtra("url");
      filename = getIntent().getStringExtra("filename");
      thumbnailUrl = getIntent().getStringExtra("thumbnailUrl");
      size = getIntent().getLongExtra("size", 0L);
    } finally {
      if (url == null || thumbnailUrl ==  null || filename == null || size == 0) {
        UIUtils.showToast(this, ResUtils.getString(this, "ch.photo.read_file_info_failed"));
        finish();
      }
    }

    photoView.setOnPhotoTapListener(this);
    buttonClose.setOnClickListener(new View.OnClickListener() {
      @Override
      public void onClick(View v) {
        finish();
      }
    });
    buttonCopyLink.setOnClickListener(new View.OnClickListener() {
      @Override
      public void onClick(View v) {
        copyLink();
      }
    });
    buttonDownload.setOnClickListener(new View.OnClickListener() {
      @Override
      public void onClick(View v) {
        download();
      }
    });

    Glide.with(this)
        .load(url)
        .asBitmap()
        .dontAnimate()
        .fitCenter()
        .into(photoView);
  }

  private void copyLink() {
    try {
      ClipboardManager clipboard = (ClipboardManager) getSystemService(CLIPBOARD_SERVICE);
      ClipData clip = ClipData.newPlainText("text", url);
      clipboard.setPrimaryClip(clip);

      UIUtils.showToast(this, ResUtils.getString(this, "ch.photo.url_copied_to_clipboard"));
    } catch (Exception ex) {
      UIUtils.showToast(this, ResUtils.getString(this, "ch.photo.read_file_info_failed"));
    }
  }

  private void download() {
    IntentUtils.setNextActivity(this, DownloadActivity.class)
        .putExtra("url", url)
        .putExtra("filename", filename)
        .putExtra("image", true)
        .startActivity();
  }

  @Override
  public void onPhotoTap(View view, float x, float y) {
    animateOverlay();
  }

  @Override
  public void onOutsidePhotoTap() {
    animateOverlay();
  }

  private void animateOverlay() {
    float from, to;

    from = menuVisible ? 1.0f : 0.0f;
    to = menuVisible ? 0.0f : 1.0f;
    menuVisible = !menuVisible;

    buttonClose.setEnabled(menuVisible);
    buttonCopyLink.setEnabled(menuVisible);
    buttonDownload.setEnabled(menuVisible);

    buttonClose.setClickable(menuVisible);
    buttonCopyLink.setClickable(menuVisible);
    buttonDownload.setClickable(menuVisible);

    AlphaAnimation animation = new AlphaAnimation(from, to);
    animation.setDuration(200);
    animation.setFillAfter(true);
    layoutOverlay.startAnimation(animation);
  }
}
