package com.zoyi.channel.plugin.android.activity.photo_picker;

import android.support.annotation.ColorInt;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.view.external.smooth_checkbox.SmoothCheckBox;
import com.zoyi.com.bumptech.glide.Glide;
import com.zoyi.com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.model.wrapper.MarginBox;

/**
 * Created by mika on 8/31/16.
 */
class PhotoHolder extends RecyclerView.ViewHolder {
  private RelativeLayout root;
  private RelativeLayout frame;
  private ImageView imageView;
  private SmoothCheckBox checkBox;
  private TextView textCount;

  private PhotoItemEventListener listener;
  private boolean singleMode;
  private String path;
  private int size;

  PhotoHolder(
      View itemView,
      boolean s,
      @ColorInt int checkedColor,
      @ColorInt int tickColor,
      int size,
      final PhotoItemEventListener l) {
    super(itemView);
    this.singleMode = s;
    this.listener = l;
    this.size = size;

    root = (RelativeLayout) itemView.findViewById(R.id.image_layout);
    frame = (RelativeLayout) itemView.findViewById(R.id.image_frame);
    imageView = (ImageView) itemView.findViewById(R.id.image_view);
    checkBox = (SmoothCheckBox) itemView.findViewById(R.id.checkbox);
    textCount = (TextView) itemView.findViewById(R.id.text_count);

    checkBox.setOnClickListener(new View.OnClickListener() {
      @Override
      public void onClick(View v) {
        checkboxClicked();
      }
    });

    root.setOnClickListener(new View.OnClickListener() {
      @Override
      public void onClick(View v) {
        if (singleMode) {
          if (listener != null) {
            listener.clicked(path);
          }
        } else {
          checkboxClicked();
        }
      }
    });

    if (singleMode) {
      checkBox.setVisibility(View.GONE);
    } else {
      textCount.setTextColor(tickColor);
      checkBox.setVisibility(View.VISIBLE);
      checkBox.setCheckedColor(checkedColor);
      checkBox.setTickColor(tickColor);
      checkBox.setClickable(false);
    }

    itemView.getLayoutParams().width = size;
    itemView.getLayoutParams().height = size;
  }

  private void checkboxClicked() {
    boolean checked = !checkBox.isChecked();
    if (listener != null) {
      int candidateIndex = listener.requestCheck(getAdapterPosition(), checked);
      if (candidateIndex >= 0) {
        textCount.setText(candidateIndex > 0 ? String.valueOf(candidateIndex) : "");
        setImageScale(candidateIndex, true);
      }
    }
  }

  private void setImageScale(int selectedIndex, boolean animate) {
    checkBox.setChecked(selectedIndex > 0, animate);
  }

  void setValue(PhotoItem photoItem, int selectedIndex, MarginBox marginBox) {
    setImageScale(selectedIndex, false);
    textCount.setText(selectedIndex > 0 ? String.valueOf(selectedIndex) : "");
    root.setPadding(
        marginBox.getLeft(),
        marginBox.getTop(),
        marginBox.getRight(),
        marginBox.getBottom());

    if (!photoItem.getPath().equals(path)) {
      path = photoItem.getPath();
      Glide.with(itemView.getContext())
          .load(photoItem.getPath())
          .diskCacheStrategy(DiskCacheStrategy.RESULT)
          .placeholder(R.drawable.ch_plugin_image_placeholder)
          .error(R.drawable.ch_plugin_image_placeholder)
          .override(size, size)
          .centerCrop()
          .into(imageView);
    }
  }
}
