/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.photo_picker;

import android.support.annotation.ColorInt;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.photo_picker.PhotoItem;
import com.zoyi.channel.plugin.android.activity.photo_picker.PhotoItemEventListener;
import com.zoyi.channel.plugin.android.model.wrapper.MarginBox;
import com.zoyi.channel.plugin.android.view.external.smooth_checkbox.SmoothCheckBox;
import com.zoyi.com.bumptech.glide.DrawableRequestBuilder;
import com.zoyi.com.bumptech.glide.Glide;
import com.zoyi.com.bumptech.glide.load.engine.DiskCacheStrategy;

public class PhotoHolder
extends RecyclerView.ViewHolder {
    RelativeLayout root;
    RelativeLayout frame;
    ImageView imageView;
    SmoothCheckBox checkBox;
    TextView textCount;
    private PhotoItemEventListener listener;
    private boolean singleMode;
    private String path;
    private int size;

    public PhotoHolder(View itemView, boolean s, @ColorInt int checkedColor, @ColorInt int tickColor, int size, PhotoItemEventListener l) {
        super(itemView);
        this.singleMode = s;
        this.listener = l;
        this.size = size;
        this.root = (RelativeLayout)itemView.findViewById(R.id.image_layout);
        this.frame = (RelativeLayout)itemView.findViewById(R.id.image_frame);
        this.imageView = (ImageView)itemView.findViewById(R.id.image_view);
        this.checkBox = (SmoothCheckBox)itemView.findViewById(R.id.checkbox);
        this.textCount = (TextView)itemView.findViewById(R.id.text_count);
        this.checkBox.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PhotoHolder.this.checkboxClicked();
            }
        });
        this.root.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (PhotoHolder.this.singleMode) {
                    if (PhotoHolder.this.listener != null) {
                        PhotoHolder.this.listener.clicked(PhotoHolder.this.path);
                    }
                } else {
                    PhotoHolder.this.checkboxClicked();
                }
            }
        });
        if (this.singleMode) {
            this.checkBox.setVisibility(8);
        } else {
            this.textCount.setTextColor(tickColor);
            this.checkBox.setVisibility(0);
            this.checkBox.setCheckedColor(checkedColor);
            this.checkBox.setTickColor(tickColor);
            this.checkBox.setClickable(false);
        }
        itemView.getLayoutParams().width = size;
        itemView.getLayoutParams().height = size;
    }

    public void checkboxClicked() {
        int candidateIndex;
        boolean checked;
        boolean bl = checked = !this.checkBox.isChecked();
        if (this.listener != null && (candidateIndex = this.listener.requestCheck(this.getAdapterPosition(), checked)) >= 0) {
            this.textCount.setText((CharSequence)(candidateIndex > 0 ? String.valueOf(candidateIndex) : ""));
            this.setImageScale(candidateIndex, true);
        }
    }

    private void setImageScale(int selectedIndex, boolean animate) {
        this.checkBox.setChecked(selectedIndex > 0, animate);
    }

    public void setValue(PhotoItem photoItem, int selectedIndex, MarginBox marginBox) {
        this.setImageScale(selectedIndex, false);
        this.textCount.setText((CharSequence)(selectedIndex > 0 ? String.valueOf(selectedIndex) : ""));
        this.root.setPadding(marginBox.getLeft(), marginBox.getTop(), marginBox.getRight(), marginBox.getBottom());
        if (!photoItem.getPath().equals(this.path)) {
            this.path = photoItem.getPath();
            ((DrawableRequestBuilder)((DrawableRequestBuilder)((DrawableRequestBuilder)((DrawableRequestBuilder)((DrawableRequestBuilder)Glide.with(this.itemView.getContext()).load(photoItem.getPath()).diskCacheStrategy(DiskCacheStrategy.RESULT)).placeholder(R.drawable.ch_plugin_image_placeholder)).error(R.drawable.ch_plugin_image_placeholder)).override(this.size, this.size)).centerCrop()).into(this.imageView);
        }
    }
}

