/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.model;

import com.zoyi.channel.plugin.android.activity.chat.model.MessageItem;
import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import com.zoyi.channel.plugin.android.util.TimeUtils;

public class ChatMessageItem
implements MessageItem {
    private Message message;
    private MessageType type;

    public ChatMessageItem() {
    }

    public ChatMessageItem(Message message) {
        this.message = message;
        this.type = this.message != null && "Manager".equals(message.getPersonType()) ? MessageType.MANAGER_MESSSAGE : MessageType.USER_MESSAGE;
    }

    @Override
    public Long getFirst() {
        switch (this.type) {
            case MANAGER_MESSSAGE: 
            case USER_MESSAGE: {
                return this.message.getCreatedAt();
            }
        }
        return 0L;
    }

    @Override
    public String getSecond() {
        switch (this.type) {
            case MANAGER_MESSSAGE: 
            case USER_MESSAGE: {
                return this.message.getId();
            }
        }
        return "";
    }

    public Message getMessage() {
        return this.message;
    }

    @Override
    public MessageType getType() {
        return this.type;
    }

    public boolean isConnected(MessageItem p2) {
        if (p2 == null || !(p2 instanceof ChatMessageItem)) {
            return false;
        }
        if (this.getType() != p2.getType()) {
            return false;
        }
        Message m1 = this.message;
        Message m2 = ((ChatMessageItem)p2).getMessage();
        if (this.getType() == MessageType.MANAGER_MESSSAGE) {
            if (m1 == null || m2 == null) {
                return false;
            }
            if (CompareUtils.compare(m1.getPersonId(), m2.getPersonId()) != 0) {
                return false;
            }
        }
        switch (this.getType()) {
            case MANAGER_MESSSAGE: 
            case USER_MESSAGE: {
                String t1 = TimeUtils.get(TimeUtils.MINUTE_24, m1.getCreatedAt());
                String t2 = TimeUtils.get(TimeUtils.MINUTE_24, m2.getCreatedAt());
                return CompareUtils.compare(t1, t2) == 0;
            }
        }
        return false;
    }
}

