package com.zoyi.channel.plugin.android.activity.userchat_list;

import com.zoyi.channel.plugin.android.ChannelPlugin;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.wrapper.UserChatsWrapper;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.channel.plugin.android.network.RetrofitException;
import com.zoyi.rx.android.schedulers.AndroidSchedulers;
import com.zoyi.rx.schedulers.Schedulers;

/**
 * Created by mika on 2016. 12. 6..
 */
class UserChatListAction {
  UserChatListActionListener listener;
  UserChatListAction(UserChatListActionListener listener) {
    this.listener = listener;
  }

  void fetchUserChats(String channelId) {
    ChannelPlugin.getService().getUserChats(Const.UPDATED_AT, Const.DESC, 50)
        .subscribeOn(Schedulers.newThread())
        .observeOn(AndroidSchedulers.mainThread())
        .subscribe(new RestSubscriber<UserChatsWrapper>() {
          @Override
          public void onError(RetrofitException error) {
            // show error
            listener.userChatsFetched(null);
          }

          @Override
          public void onNext(UserChatsWrapper userChatsWrapper) {
            listener.userChatsFetched(userChatsWrapper);
          }
        });
  }
}
