package com.zoyi.channel.plugin.android.activity.chat;

import android.content.Context;
import com.zoyi.channel.plugin.android.model.Pair;
import com.zoyi.channel.plugin.android.util.Utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

/**
 * Created by mika on 2017. 2. 7..
 */
public class CountryDictionary {
  private List<Pair> countries;
  private List<String> countryNames;

  public CountryDictionary(Context context) {
    countries = new ArrayList<>();
    countries.add(new Pair("us", "1"));
    countries.add(new Pair("ca", "1"));
    countries.add(new Pair("ru", "7"));
    countries.add(new Pair("za", "7"));
    countries.add(new Pair("fr", "33"));
    countries.add(new Pair("it", "39"));
    countries.add(new Pair("gb", "44"));
    countries.add(new Pair("de", "49"));
    countries.add(new Pair("mx", "52"));
    countries.add(new Pair("ar", "54"));
    countries.add(new Pair("br", "55"));
    countries.add(new Pair("my", "60"));
    countries.add(new Pair("au", "61"));
    countries.add(new Pair("id", "62"));
    countries.add(new Pair("ph", "63"));
    countries.add(new Pair("sg", "65"));
    countries.add(new Pair("th", "66"));
    countries.add(new Pair("jp", "81"));
    countries.add(new Pair("kr", "82"));
    countries.add(new Pair("vn", "84"));
    countries.add(new Pair("cn", "86"));
    countries.add(new Pair("tr", "90"));
    countries.add(new Pair("in", "91"));
    countries.add(new Pair("hk", "852"));
    countries.add(new Pair("mo", "853"));
    countries.add(new Pair("tw", "886"));
    countries.add(new Pair("sa", "966"));

    countryNames = new ArrayList<>();

    for (Pair pair : countries) {
      countryNames.add(
          Utils.getString(
              context,
              String.format("ch.mobile_verification.country.%s", pair.getFirst())));
    }
  }

  public String getDefaultCountryCode() {
    String lang = Locale.getDefault().getLanguage().toUpperCase();
    switch (lang) {
      case "KO":
        return "82";
      case "JA":
        return "81";
      default:
        return "1";
    }
  }

  public List<String> getCountryNames() {
    return countryNames;
  }

  public String getCode(int index) {
    if (index >= 0 && index < countries.size()) {
      return countries.get(index).getSecond();
    }
    return "0";
  }
}
