package com.zoyi.channel.plugin.android.activity.camera;

/**
 * Created by mika on 2016. 4. 27..
 */

import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.provider.MediaStore;
import android.util.Log;
import com.zoyi.rx.Observable;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.android.schedulers.AndroidSchedulers;
import com.zoyi.rx.schedulers.Schedulers;

import java.io.*;

public class RxImageConverters {
  public static Observable<File> uriToFile(final Context context, final Uri uri, final File file) {
    return Observable.create(new Observable.OnSubscribe<File>() {
      @Override
      public void call(Subscriber<? super File> subscriber) {
        try {
          InputStream inputStream = context.getContentResolver().openInputStream(uri);
          copyInputStreamToFile(inputStream, file);
          subscriber.onNext(file);
          subscriber.onCompleted();
        } catch (Exception e) {
          Log.e(RxImageConverters.class.getSimpleName(), "Error converting uri", e);
          subscriber.onError(e);
        }
      }
    }).subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread());
  }

  public static Observable<Bitmap> uriToBitmap(final Context context, final Uri uri) {
    return Observable.create(new Observable.OnSubscribe<Bitmap>() {
      @Override
      public void call(Subscriber<? super Bitmap> subscriber) {

        try {
          Bitmap bitmap = MediaStore.Images.Media.getBitmap(context.getContentResolver(), uri);
          subscriber.onNext(bitmap);
          subscriber.onCompleted();
        } catch (IOException e) {
          Log.e(RxImageConverters.class.getSimpleName(), "Error converting uri", e);
          subscriber.onError(e);
        }
      }
    }).subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread());
  }

  private static void copyInputStreamToFile(InputStream in, File file) throws IOException {
    OutputStream out = new FileOutputStream(file);
    byte[] buf = new byte[10 * 1024];
    int len;
    while ((len = in.read(buf)) > 0) {
      out.write(buf, 0, len);
    }
    out.close();
    in.close();
  }
}
