/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.layout;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.enumerate.ActionType;
import com.zoyi.channel.plugin.android.view.layout.MaskableFrameLayout;

public class MenuButton
extends RelativeLayout {
    MaskableFrameLayout mask;
    FrameLayout colorLayout;
    ImageView dummy;
    Drawable iconId;
    int color = -1;
    private ActionType action;

    public MenuButton(Context context) {
        super(context);
        this.init(context, null);
    }

    public MenuButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public MenuButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    @TargetApi(value=21)
    public MenuButton(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs) {
        View view = LayoutInflater.from((Context)context).inflate(R.layout.ch_plugin_layout_menu_button, (ViewGroup)this);
        this.mask = (MaskableFrameLayout)this.findViewById(R.id.menu_icon_mask);
        this.colorLayout = (FrameLayout)this.findViewById(R.id.layout_color);
        this.dummy = (ImageView)this.findViewById(R.id.menu_icon_dummy);
        if (attrs != null) {
            TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.MenuButton, 0, 0);
            try {
                this.color = typedArray.getColor(R.styleable.MenuButton_back_color, this.color);
                this.iconId = typedArray.getDrawable(R.styleable.MenuButton_image);
            }
            finally {
                typedArray.recycle();
            }
        }
        this.setIcon(this.iconId);
        this.setColor(this.color);
    }

    public void setIcon(Drawable drawable2) {
        if (drawable2 != null) {
            this.mask.setMask(drawable2);
            this.dummy.setImageDrawable(drawable2);
        }
    }

    public void setColor(int color2) {
        this.colorLayout.setBackgroundColor(color2);
    }

    public void setAction(ActionType action) {
        this.action = action;
        if (action != null && action.getIcon() != 0) {
            this.mask.setMask(action.getIcon());
            this.dummy.setImageResource(action.getIcon());
        }
    }

    public ActionType getAction() {
        return this.action;
    }
}

